/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.httpclient;

import de.mklinger.qetcher.client.httpclient.HttpRequest;
import de.mklinger.qetcher.client.httpclient.internal.ByteArrayBodyProvider;
import de.mklinger.qetcher.client.httpclient.internal.ByteBufferBodyProvider;
import de.mklinger.qetcher.client.httpclient.internal.ContentTypeBodyProvider;
import de.mklinger.qetcher.client.httpclient.internal.FileBodyProvider;
import de.mklinger.qetcher.client.httpclient.internal.InputStreamBodyProvider;
import de.mklinger.qetcher.client.httpclient.internal.NoBodyProvider;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.function.Supplier;

public class BodyProviders {
    private BodyProviders() {
    }

    public static HttpRequest.BodyProvider noBody() {
        return NoBodyProvider.getInstance();
    }

    public static HttpRequest.BodyProvider fromByteArray(byte[] b) {
        return new ByteArrayBodyProvider(b);
    }

    public static HttpRequest.BodyProvider fromByteBuffer(ByteBuffer byteBuffer) {
        return new ByteBufferBodyProvider(byteBuffer);
    }

    public static HttpRequest.BodyProvider fromFile(Path file) {
        return new FileBodyProvider(file);
    }

    public static HttpRequest.BodyProvider fromInputStream(Supplier<InputStream> inputStreamSupplier) {
        return new InputStreamBodyProvider(inputStreamSupplier);
    }

    public static HttpRequest.BodyProvider contentType(String contentType, HttpRequest.BodyProvider bodyProvider) {
        return new ContentTypeBodyProvider(contentType, bodyProvider);
    }
}

