package de.mklinger.qetcher.client;

import java.io.InputStream;
import java.util.Properties;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class QetcherClientVersion {
	private static final Logger LOG = LoggerFactory.getLogger(QetcherClientVersion.class);

	private static final String VERSION_PROPERTIES = "version.properties";

	private static volatile String version;

	/** Not to be instantiated. */
	private QetcherClientVersion() {}

	public static String getVersion() {
		if (version == null) {
			synchronized (QetcherClientVersion.class) {
				if (version == null) {
					try (InputStream in = QetcherClientVersion.class.getResourceAsStream(VERSION_PROPERTIES)) {
						final Properties versionProperties = new Properties();
						versionProperties.load(in);
						version = versionProperties.getProperty("qetcher.client.version");
					} catch (final Exception e) {
						LOG.error("Error loading version properties", e);
					}
					if (version == null) {
						version = "unknown-version";
					}
				}
			}
		}
		return version;
	}
}
