/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.httpclient.internal;

import de.mklinger.qetcher.client.httpclient.HttpRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class InputStreamBodyProvider
implements HttpRequest.BodyProvider {
    private static final int CHUNK_SIZE = 4096;
    private final Supplier<InputStream> inputStreamSupplier;

    public InputStreamBodyProvider(Supplier<InputStream> inputStreamSupplier) {
        this.inputStreamSupplier = inputStreamSupplier;
    }

    @Override
    public Iterator<CompletableFuture<ByteBuffer>> iterator() {
        return new InputStreamIterator(this.inputStreamSupplier.get());
    }

    @Override
    public long contentLength() {
        return -1L;
    }

    private static class InputStreamIterator
    implements Iterator<CompletableFuture<ByteBuffer>> {
        private final InputStream inputStream;
        private final AtomicBoolean reading;
        private final AtomicBoolean done;
        private final byte[] buf;

        private InputStreamIterator(InputStream inputStream) {
            this.inputStream = inputStream;
            this.reading = new AtomicBoolean(false);
            this.done = new AtomicBoolean(false);
            this.buf = new byte[4096];
        }

        @Override
        public boolean hasNext() {
            if (this.reading.get()) {
                throw new IllegalStateException("Reading in progress");
            }
            return !this.done.get();
        }

        @Override
        public CompletableFuture<ByteBuffer> next() {
            ByteBuffer byteBuffer;
            if (!this.reading.compareAndSet(false, true)) {
                throw new IllegalStateException("Reading in progress");
            }
            try {
                int numRead = this.inputStream.read(this.buf, 0, this.buf.length);
                if (numRead == -1) {
                    this.done.set(true);
                    byteBuffer = ByteBuffer.allocate(0);
                } else if (numRead == 0) {
                    byteBuffer = ByteBuffer.allocate(0);
                } else {
                    byteBuffer = ByteBuffer.allocate(numRead);
                    byteBuffer.put(this.buf, 0, numRead);
                    byteBuffer.flip();
                }
                this.unsetReading();
            }
            catch (Throwable e) {
                throw this.closeStreamAndRethrowUncheckedAfterRead(e);
            }
            return CompletableFuture.completedFuture(byteBuffer);
        }

        private RuntimeException closeStreamAndRethrowUncheckedAfterRead(Throwable e1) {
            RuntimeException ex = e1 instanceof IOException ? new UncheckedIOException((IOException)e1) : new RuntimeException(e1);
            try {
                this.inputStream.close();
            }
            catch (Throwable e2) {
                ex.addSuppressed(e2);
            }
            try {
                this.unsetReading();
            }
            catch (Throwable e2) {
                ex.addSuppressed(e2);
            }
            throw ex;
        }

        private void unsetReading() {
            if (!this.reading.compareAndSet(true, false)) {
                throw new IllegalStateException("Reading was not in progress");
            }
        }
    }
}

