/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.model.v1;

import de.mklinger.qetcher.client.annotations.Nullable;
import de.mklinger.qetcher.client.model.v1.LinkedCaseInsensitiveMap;
import de.mklinger.qetcher.client.model.v1.MediaTypeParseException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

public class MediaType {
    private static final String WILDCARD = "*";
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;
    private static final char[] charsNeedingQuotation = "()<>@,;:\\\"/[]?= \t\r\n".toCharArray();

    public MediaType(@Nullable String type, @Nullable String subtype, @Nullable Map<String, String> parameters) {
        this(type, subtype, MediaType.newParameterMap(parameters), true);
    }

    private static Map<String, String> newParameterMap(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedCaseInsensitiveMap<String> parameterMap = new LinkedCaseInsensitiveMap<String>(Locale.US);
        parameterMap.putAll(parameters);
        return parameterMap;
    }

    private MediaType(@Nullable String type, @Nullable String subtype, Map<String, String> parameters, boolean discriminator) {
        this.type = type == null ? WILDCARD : type;
        this.subtype = subtype == null ? WILDCARD : subtype;
        if (WILDCARD.equals(this.type) && !WILDCARD.equals(this.subtype)) {
            throw new IllegalArgumentException("Media type wildcard type is legal only in '*/*' (all mime types)");
        }
        this.parameters = Collections.unmodifiableMap(parameters);
    }

    public MediaType(@Nullable String type, @Nullable String subtype) {
        this(type, subtype, null);
    }

    public static MediaType valueOf(String type) {
        return MediaType.parse(type);
    }

    public String getType() {
        return this.type;
    }

    public boolean isWildcardType() {
        return this.getType().equals(WILDCARD);
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean isWildcardSubtype() {
        return this.getSubtype().equals(WILDCARD);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public MediaType withoutParameters() {
        if (this.parameters == null || this.parameters.isEmpty()) {
            return this;
        }
        return new MediaType(this.type, this.subtype);
    }

    public MediaType withoutParameters(String ... names) {
        assert (names != null);
        assert (names.length > 0);
        if (this.parameters == null || this.parameters.isEmpty()) {
            return this;
        }
        Map<String, String> newParameters = MediaType.newParameterMap(this.parameters);
        for (String name : names) {
            newParameters.remove(name);
        }
        return new MediaType(this.type, this.subtype, newParameters, true);
    }

    public MediaType withParameter(String name, String value) {
        return this.withParameters(Collections.singletonMap(name, value));
    }

    public MediaType withParameters(Map<String, String> additionalParameters) {
        if (additionalParameters == null || additionalParameters.isEmpty()) {
            return this;
        }
        if (this.parameters == null || this.parameters.isEmpty()) {
            return new MediaType(this.type, this.subtype, additionalParameters);
        }
        Map<String, String> allParameters = MediaType.newParameterMap(this.parameters);
        allParameters.putAll(additionalParameters);
        return new MediaType(this.type, this.subtype, allParameters, true);
    }

    public boolean isCompatible(MediaType other) {
        return other != null && (this.type.equals(WILDCARD) || other.type.equals(WILDCARD) || this.type.equalsIgnoreCase(other.type) && (this.subtype.equals(WILDCARD) || other.subtype.equals(WILDCARD)) || this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MediaType)) {
            return false;
        }
        MediaType other = (MediaType)obj;
        return this.type.equalsIgnoreCase(other.type) && this.subtype.equalsIgnoreCase(other.subtype) && this.parameters.equals(other.parameters);
    }

    public int hashCode() {
        return (this.type.toLowerCase() + this.subtype.toLowerCase()).hashCode() + this.parameters.hashCode();
    }

    public String toString() {
        return MediaType.toString(this, true);
    }

    public String getFullType() {
        return MediaType.toString(this, false);
    }

    private static String toString(MediaType type, boolean withParameters) {
        if (type == null) {
            throw new IllegalArgumentException("param was null");
        }
        int len = type.getType().length() + 1 + type.getSubtype().length();
        for (Map.Entry<String, String> parameter : type.getParameters().entrySet()) {
            len += parameter.getKey().length() + parameter.getValue().length() + 4;
        }
        StringBuilder buf = new StringBuilder(len);
        buf.append(type.getType().toLowerCase());
        buf.append("/");
        buf.append(type.getSubtype().toLowerCase());
        if (!withParameters || type.getParameters() == null || type.getParameters().isEmpty()) {
            return buf.toString();
        }
        for (Map.Entry<String, String> parameter : type.getParameters().entrySet()) {
            buf.append(';');
            buf.append(parameter.getKey());
            String val = parameter.getValue();
            if (val.isEmpty()) continue;
            buf.append('=');
            if (MediaType.needsQuotation(val)) {
                buf.append('\"');
                buf.append(val);
                buf.append('\"');
                continue;
            }
            buf.append(val);
        }
        return buf.toString();
    }

    private static boolean needsQuotation(String str) {
        for (int idx = 0; idx < str.length(); ++idx) {
            for (char q : charsNeedingQuotation) {
                if (str.charAt(idx) != q) continue;
                return true;
            }
        }
        return false;
    }

    private static MediaType parse(String mediaType) {
        int subIndex;
        if (mediaType == null || mediaType.isEmpty()) {
            throw new MediaTypeParseException("Media type must not be empty");
        }
        int semicolonIdx = mediaType.indexOf(59);
        String fullType = semicolonIdx >= 0 ? mediaType.substring(0, semicolonIdx).trim() : mediaType.trim();
        if (fullType.isEmpty()) {
            throw new MediaTypeParseException("Media type must not be empty");
        }
        if (WILDCARD.equals(fullType)) {
            fullType = "*/*";
        }
        if ((subIndex = fullType.indexOf(47)) == -1) {
            throw new MediaTypeParseException("Media type does not contain '/': '" + mediaType + "'");
        }
        if (subIndex == fullType.length() - 1) {
            throw new MediaTypeParseException("Media type does not contain subtype after '/': '" + mediaType + "'");
        }
        String type = MediaType.requireToken(fullType.substring(0, subIndex), () -> "Invalid type in media type: '" + mediaType + "'");
        String subtype = MediaType.requireToken(fullType.substring(subIndex + 1, fullType.length()), () -> "Invalid sub-type in media type: '" + mediaType + "'");
        if (WILDCARD.equals(type) && !WILDCARD.equals(subtype)) {
            throw new MediaTypeParseException("Media type wildcard type is legal only in '*/*' (all mime types)");
        }
        Map<String, String> parameters = MediaType.parseParameters(mediaType, semicolonIdx);
        return new MediaType(type, subtype, parameters, true);
    }

    private static String requireToken(String token, Supplier<String> messageSupplier) {
        if (token.isEmpty()) {
            throw new MediaTypeParseException(messageSupplier.get());
        }
        for (int idx = 0; idx < token.length(); ++idx) {
            char c = token.charAt(idx);
            switch (c) {
                case '\'': 
                case '(': 
                case ')': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': {
                    throw new MediaTypeParseException(messageSupplier.get());
                }
            }
            if (c > ' ' && c < '\u007f') continue;
            throw new MediaTypeParseException(messageSupplier.get());
        }
        return token;
    }

    private static Map<String, String> parseParameters(String mediaType, int initialStartIndex) {
        int startIdx = initialStartIndex;
        LinkedCaseInsensitiveMap<String> parameters = null;
        while (startIdx >= 0 && startIdx < mediaType.length()) {
            String value;
            if (mediaType.charAt(startIdx) != ';') {
                throw new IllegalStateException();
            }
            int eqIdx = mediaType.indexOf(61, startIdx + 1);
            if (eqIdx == -1) {
                throw new MediaTypeParseException("Missing '=' in media type parameters: '" + mediaType + "'");
            }
            String name = mediaType.substring(startIdx + 1, eqIdx).trim();
            if (name.isEmpty()) {
                throw new MediaTypeParseException("Missing name in media type parameters: '" + mediaType + "'");
            }
            int valueStartIdx = eqIdx + 1;
            if (valueStartIdx >= mediaType.length()) {
                throw new MediaTypeParseException("Missing value in media type parameters: '" + mediaType + "'");
            }
            char firstValueChar = mediaType.charAt(valueStartIdx);
            if (firstValueChar == '\"') {
                int quoteEndIdx = mediaType.indexOf(34, valueStartIdx + 1);
                if (quoteEndIdx == -1) {
                    throw new MediaTypeParseException("Illegal value quotation in media type parameters: '" + mediaType + "'");
                }
                value = mediaType.substring(valueStartIdx + 1, quoteEndIdx);
                for (startIdx = quoteEndIdx + 1; startIdx < mediaType.length() && mediaType.charAt(startIdx) == ' '; ++startIdx) {
                }
            } else {
                int endIdx = mediaType.indexOf(59, valueStartIdx);
                value = endIdx == -1 ? mediaType.substring(valueStartIdx) : mediaType.substring(valueStartIdx, endIdx);
                startIdx = endIdx;
            }
            if (parameters == null) {
                parameters = new LinkedCaseInsensitiveMap<String>(Locale.US);
            }
            parameters.put(name, value);
        }
        return MediaType.newParameterMap(parameters);
    }

    public Optional<String> getParameter(String name) {
        String value = this.getParameters().get(name);
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public Optional<Integer> getIntegerParameter(String name) {
        String value = this.getParameters().get(name);
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Integer.valueOf(value));
    }

    public Optional<Boolean> getBooleanParameter(String name) {
        String value = this.getParameters().get(name);
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Boolean.valueOf(value));
    }

    public boolean getBooleanParameter(String name, boolean defaultValue) {
        return this.getBooleanParameter(name).orElse(defaultValue);
    }
}

