/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.jetty.util.thread;

import de.mklinger.qetcher.client.jetty.util.ProcessorUtils;
import de.mklinger.qetcher.client.jetty.util.log.Log;
import de.mklinger.qetcher.client.jetty.util.log.Logger;
import de.mklinger.qetcher.client.jetty.util.thread.ThreadPool;
import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public class ThreadPoolBudget {
    static final Logger LOG = Log.getLogger(ThreadPoolBudget.class);
    private static final Lease NOOP_LEASE = new Lease(){

        @Override
        public void close() throws IOException {
        }

        @Override
        public int getThreads() {
            return 0;
        }
    };
    final ThreadPool.SizedThreadPool pool;
    final Set<Leased> allocations = new CopyOnWriteArraySet<Leased>();
    final Set<Leased> info = new CopyOnWriteArraySet<Leased>();
    final AtomicBoolean warned = new AtomicBoolean();
    final int warnAt;

    public ThreadPoolBudget(ThreadPool.SizedThreadPool pool) {
        this(pool, Math.min(ProcessorUtils.availableProcessors(), pool.getMinThreads()));
    }

    public ThreadPoolBudget(ThreadPool.SizedThreadPool pool, int warnAt) {
        this.pool = pool;
        this.warnAt = warnAt;
    }

    public ThreadPool.SizedThreadPool getSizedThreadPool() {
        return this.pool;
    }

    public void reset() {
        this.allocations.clear();
        this.info.clear();
        this.warned.set(false);
    }

    public Lease leaseTo(Object leasee, int threads) {
        Leased lease = new Leased(leasee, threads);
        this.allocations.add(lease);
        this.check();
        return lease;
    }

    public void check() throws IllegalStateException {
        int required = this.allocations.stream().mapToInt(Lease::getThreads).sum();
        int maximum = this.pool.getMaxThreads();
        int actual = maximum - required;
        if (actual <= 0) {
            this.infoOnLeases();
            throw new IllegalStateException(String.format("Insufficient configured threads: required=%d < max=%d for %s", required, maximum, this.pool));
        }
        if (actual < this.warnAt) {
            this.infoOnLeases();
            if (this.warned.compareAndSet(false, true)) {
                LOG.warn("Low configured threads: (max={} - required={})={} < warnAt={} for {}", maximum, required, actual, this.warnAt, this.pool);
            }
        }
    }

    private void infoOnLeases() {
        this.allocations.stream().filter(lease -> !this.info.contains(lease)).forEach(lease -> {
            this.info.add((Leased)lease);
            LOG.info("{} requires {} threads from {}", lease.leasee, lease.getThreads(), this.pool);
        });
    }

    public static Lease leaseFrom(Executor executor, Object leasee, int threads) {
        ThreadPoolBudget budget;
        if (executor instanceof ThreadPool.SizedThreadPool && (budget = ((ThreadPool.SizedThreadPool)executor).getThreadPoolBudget()) != null) {
            return budget.leaseTo(leasee, threads);
        }
        return NOOP_LEASE;
    }

    public class Leased
    implements Lease {
        final Object leasee;
        final int threads;

        private Leased(Object leasee, int threads) {
            this.leasee = leasee;
            this.threads = threads;
        }

        @Override
        public int getThreads() {
            return this.threads;
        }

        @Override
        public void close() {
            ThreadPoolBudget.this.info.remove(this);
            ThreadPoolBudget.this.allocations.remove(this);
            ThreadPoolBudget.this.warned.set(false);
        }
    }

    public static interface Lease
    extends Closeable {
        public int getThreads();
    }
}

