/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.jetty.http2.frames;

import de.mklinger.qetcher.client.jetty.http2.frames.Frame;
import de.mklinger.qetcher.client.jetty.http2.frames.FrameType;

public class PriorityFrame
extends Frame {
    public static final int PRIORITY_LENGTH = 5;
    private final int streamId;
    private final int parentStreamId;
    private final int weight;
    private final boolean exclusive;

    public PriorityFrame(int parentStreamId, int weight, boolean exclusive) {
        this(0, parentStreamId, weight, exclusive);
    }

    public PriorityFrame(int streamId, int parentStreamId, int weight, boolean exclusive) {
        super(FrameType.PRIORITY);
        this.streamId = streamId;
        this.parentStreamId = parentStreamId;
        this.weight = weight;
        this.exclusive = exclusive;
    }

    public int getStreamId() {
        return this.streamId;
    }

    @Deprecated
    public int getDependentStreamId() {
        return this.getParentStreamId();
    }

    public int getParentStreamId() {
        return this.parentStreamId;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    @Override
    public String toString() {
        return String.format("%s#%d/#%d{weight=%d,exclusive=%b}", super.toString(), this.streamId, this.parentStreamId, this.weight, this.exclusive);
    }
}

