/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.jetty.http2.client.http;

import de.mklinger.qetcher.client.jetty.client.HttpContent;
import de.mklinger.qetcher.client.jetty.client.HttpExchange;
import de.mklinger.qetcher.client.jetty.client.HttpRequest;
import de.mklinger.qetcher.client.jetty.client.HttpSender;
import de.mklinger.qetcher.client.jetty.http.HttpFields;
import de.mklinger.qetcher.client.jetty.http.HttpURI;
import de.mklinger.qetcher.client.jetty.http.HttpVersion;
import de.mklinger.qetcher.client.jetty.http.MetaData;
import de.mklinger.qetcher.client.jetty.http2.IStream;
import de.mklinger.qetcher.client.jetty.http2.api.Stream;
import de.mklinger.qetcher.client.jetty.http2.client.http.HttpChannelOverHTTP2;
import de.mklinger.qetcher.client.jetty.http2.frames.DataFrame;
import de.mklinger.qetcher.client.jetty.http2.frames.HeadersFrame;
import de.mklinger.qetcher.client.jetty.util.Callback;
import de.mklinger.qetcher.client.jetty.util.Promise;
import java.net.URI;
import java.util.function.Supplier;

public class HttpSenderOverHTTP2
extends HttpSender {
    public HttpSenderOverHTTP2(HttpChannelOverHTTP2 channel) {
        super(channel);
    }

    @Override
    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    @Override
    protected void sendHeaders(HttpExchange exchange, final HttpContent content, final Callback callback) {
        final HttpRequest request = exchange.getRequest();
        String path = this.relativize(request.getPath());
        HttpURI uri = HttpURI.createHttpURI(request.getScheme(), request.getHost(), request.getPort(), path, null, request.getQuery(), null);
        MetaData.Request metaData = new MetaData.Request(request.getMethod(), uri, HttpVersion.HTTP_2, request.getHeaders());
        final Supplier<HttpFields> trailers = request.getTrailers();
        metaData.setTrailerSupplier(trailers);
        HeadersFrame headersFrame = new HeadersFrame(metaData, null, trailers == null && !content.hasContent());
        final HttpChannelOverHTTP2 channel = this.getHttpChannel();
        Promise<Stream> promise = new Promise<Stream>(){

            @Override
            public void succeeded(Stream stream) {
                channel.setStream(stream);
                ((IStream)stream).setAttachment(channel);
                stream.setIdleTimeout(request.getIdleTimeout());
                if (content.hasContent() && !HttpSenderOverHTTP2.this.expects100Continue(request)) {
                    boolean lastContent;
                    boolean advanced = content.advance();
                    boolean bl = lastContent = trailers == null && content.isLast();
                    if (advanced || lastContent) {
                        DataFrame dataFrame = new DataFrame(stream.getId(), content.getByteBuffer(), lastContent);
                        stream.data(dataFrame, callback);
                        return;
                    }
                }
                callback.succeeded();
            }

            @Override
            public void failed(Throwable failure) {
                callback.failed(failure);
            }
        };
        channel.getSession().newStream(headersFrame, promise, channel.getStreamListener());
    }

    private String relativize(String path) {
        try {
            String result = path;
            URI uri = URI.create(result);
            if (uri.isAbsolute()) {
                result = uri.getPath();
            }
            return result.isEmpty() ? "/" : result;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not relativize " + path, new Object[0]);
            }
            return path;
        }
    }

    @Override
    protected void sendContent(HttpExchange exchange, HttpContent content, Callback callback) {
        if (content.isConsumed()) {
            callback.succeeded();
        } else {
            Stream stream = this.getHttpChannel().getStream();
            Supplier<HttpFields> trailers = exchange.getRequest().getTrailers();
            DataFrame frame = new DataFrame(stream.getId(), content.getByteBuffer(), trailers == null && content.isLast());
            stream.data(frame, callback);
        }
    }

    @Override
    protected void sendTrailers(HttpExchange exchange, Callback callback) {
        Supplier<HttpFields> trailers = exchange.getRequest().getTrailers();
        MetaData metaData = new MetaData(HttpVersion.HTTP_2, trailers.get());
        Stream stream = this.getHttpChannel().getStream();
        HeadersFrame trailersFrame = new HeadersFrame(stream.getId(), metaData, null, true);
        stream.headers(trailersFrame, callback);
    }
}

