/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.jetty.http2.client.http;

import de.mklinger.qetcher.client.jetty.client.HttpChannel;
import de.mklinger.qetcher.client.jetty.client.HttpExchange;
import de.mklinger.qetcher.client.jetty.client.HttpReceiver;
import de.mklinger.qetcher.client.jetty.client.HttpRequest;
import de.mklinger.qetcher.client.jetty.client.HttpResponse;
import de.mklinger.qetcher.client.jetty.client.api.Request;
import de.mklinger.qetcher.client.jetty.client.api.Response;
import de.mklinger.qetcher.client.jetty.http.HttpField;
import de.mklinger.qetcher.client.jetty.http.HttpFields;
import de.mklinger.qetcher.client.jetty.http.HttpStatus;
import de.mklinger.qetcher.client.jetty.http.MetaData;
import de.mklinger.qetcher.client.jetty.http2.ErrorCode;
import de.mklinger.qetcher.client.jetty.http2.api.Stream;
import de.mklinger.qetcher.client.jetty.http2.client.http.HttpChannelOverHTTP2;
import de.mklinger.qetcher.client.jetty.http2.frames.DataFrame;
import de.mklinger.qetcher.client.jetty.http2.frames.HeadersFrame;
import de.mklinger.qetcher.client.jetty.http2.frames.PushPromiseFrame;
import de.mklinger.qetcher.client.jetty.http2.frames.ResetFrame;
import de.mklinger.qetcher.client.jetty.util.BufferUtil;
import de.mklinger.qetcher.client.jetty.util.Callback;
import de.mklinger.qetcher.client.jetty.util.IteratingCallback;
import de.mklinger.qetcher.client.jetty.util.Retainable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.function.BiFunction;

public class HttpReceiverOverHTTP2
extends HttpReceiver
implements Stream.Listener {
    private final ContentNotifier contentNotifier = new ContentNotifier();

    public HttpReceiverOverHTTP2(HttpChannel channel) {
        super(channel);
    }

    @Override
    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    @Override
    protected void reset() {
        super.reset();
        this.contentNotifier.reset();
    }

    @Override
    public void onHeaders(Stream stream, HeadersFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        HttpResponse httpResponse = exchange.getResponse();
        MetaData metaData = frame.getMetaData();
        if (metaData.isResponse()) {
            MetaData.Response response = (MetaData.Response)frame.getMetaData();
            httpResponse.version(response.getHttpVersion()).status(response.getStatus()).reason(response.getReason());
            if (this.responseBegin(exchange)) {
                HttpFields headers = response.getFields();
                for (HttpField header : headers) {
                    if (this.responseHeader(exchange, header)) continue;
                    return;
                }
                if (this.responseHeaders(exchange)) {
                    boolean informational;
                    int status = response.getStatus();
                    boolean bl = informational = HttpStatus.isInformational(status) && status != 101;
                    if (frame.isEndStream() || informational) {
                        this.responseSuccess(exchange);
                    }
                }
            }
        } else {
            HttpFields trailers = metaData.getFields();
            trailers.forEach(httpResponse::trailer);
            this.notifyContent(exchange, new DataFrame(stream.getId(), BufferUtil.EMPTY_BUFFER, true), Callback.NOOP);
        }
    }

    @Override
    public Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
        Response.CompleteListener listener;
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return null;
        }
        HttpRequest request = exchange.getRequest();
        MetaData.Request metaData = (MetaData.Request)frame.getMetaData();
        HttpRequest pushRequest = (HttpRequest)this.getHttpDestination().getHttpClient().newRequest(metaData.getURIString());
        BiFunction<Request, Request, Response.CompleteListener> pushListener = request.getPushListener();
        if (pushListener != null && (listener = pushListener.apply(request, pushRequest)) != null) {
            HttpChannelOverHTTP2 pushChannel = this.getHttpChannel().getHttpConnection().acquireHttpChannel();
            List<Response.ResponseListener> listeners = Collections.singletonList(listener);
            HttpExchange pushExchange = new HttpExchange(this.getHttpDestination(), pushRequest, listeners);
            pushChannel.associate(pushExchange);
            pushChannel.setStream(stream);
            pushExchange.requestComplete(null);
            pushExchange.terminateRequest();
            return pushChannel.getStreamListener();
        }
        stream.reset(new ResetFrame(stream.getId(), ErrorCode.REFUSED_STREAM_ERROR.code), Callback.NOOP);
        return null;
    }

    @Override
    public void onData(Stream stream, DataFrame frame, Callback callback) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            callback.failed(new IOException("terminated"));
        } else {
            this.notifyContent(exchange, frame, callback);
        }
    }

    @Override
    public void onReset(Stream stream, ResetFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        ErrorCode error = ErrorCode.from(frame.getError());
        String reason = error == null ? "reset" : error.name().toLowerCase(Locale.ENGLISH);
        exchange.getRequest().abort(new IOException(reason));
    }

    @Override
    public boolean onIdleTimeout(Stream stream, Throwable x) {
        this.responseFailure(x);
        return true;
    }

    private void notifyContent(HttpExchange exchange, DataFrame frame, Callback callback) {
        this.contentNotifier.offer(new DataInfo(exchange, frame, callback));
        this.contentNotifier.iterate();
    }

    private static class DataInfo {
        private final HttpExchange exchange;
        private final DataFrame frame;
        private final Callback callback;

        private DataInfo(HttpExchange exchange, DataFrame frame, Callback callback) {
            this.exchange = exchange;
            this.frame = frame;
            this.callback = callback;
        }
    }

    private class ContentNotifier
    extends IteratingCallback
    implements Retainable {
        private final Queue<DataInfo> queue = new ArrayDeque<DataInfo>();
        private DataInfo dataInfo;

        private ContentNotifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void offer(DataInfo dataInfo) {
            ContentNotifier contentNotifier = this;
            synchronized (contentNotifier) {
                this.queue.offer(dataInfo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected IteratingCallback.Action process() {
            DataInfo dataInfo;
            ContentNotifier contentNotifier = this;
            synchronized (contentNotifier) {
                dataInfo = this.queue.poll();
            }
            if (dataInfo == null) {
                DataInfo prevDataInfo = this.dataInfo;
                if (prevDataInfo != null && prevDataInfo.frame.isEndStream()) {
                    return IteratingCallback.Action.SUCCEEDED;
                }
                return IteratingCallback.Action.IDLE;
            }
            this.dataInfo = dataInfo;
            ByteBuffer buffer = dataInfo.frame.getData();
            if (buffer.hasRemaining()) {
                HttpReceiverOverHTTP2.this.responseContent(dataInfo.exchange, buffer, this);
            } else {
                this.succeeded();
            }
            return IteratingCallback.Action.SCHEDULED;
        }

        @Override
        public void retain() {
            Callback callback = this.dataInfo.callback;
            if (callback instanceof Retainable) {
                ((Retainable)((Object)callback)).retain();
            }
        }

        @Override
        public void succeeded() {
            this.dataInfo.callback.succeeded();
            super.succeeded();
        }

        @Override
        protected void onCompleteSuccess() {
            HttpReceiverOverHTTP2.this.responseSuccess(this.dataInfo.exchange);
        }

        @Override
        protected void onCompleteFailure(Throwable failure) {
            this.dataInfo.callback.failed(failure);
            HttpReceiverOverHTTP2.this.responseFailure(failure);
        }
    }
}

