/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.impl.lookup;

import de.mklinger.qetcher.client.impl.lookup.ServiceUriSupplier;
import java.net.URI;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class StaticServiceUriSupplier
implements ServiceUriSupplier {
    private final List<URI> serviceUris;

    public StaticServiceUriSupplier(List<URI> serviceUris) {
        this.serviceUris = StaticServiceUriSupplier.requireNonEmpty(serviceUris);
    }

    private static <T> List<T> requireNonEmpty(List<T> l) {
        if (l == null || l.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return l;
    }

    @Override
    public URI get() {
        int randomIdx = ThreadLocalRandom.current().nextInt(this.serviceUris.size());
        return this.serviceUris.get(randomIdx);
    }
}

