/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.httpclient;

import de.mklinger.qetcher.client.httpclient.HttpResponse;
import de.mklinger.qetcher.client.httpclient.internal.ByteArrayCompleteListener;
import de.mklinger.qetcher.client.httpclient.internal.DiscardBodyCompleteListener;
import de.mklinger.qetcher.client.httpclient.internal.FileCompleteListener;
import de.mklinger.qetcher.client.httpclient.internal.StringBodyHandler;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class BodyHandlers {
    private BodyHandlers() {
    }

    public static HttpResponse.BodyHandler<Path> asFile(Path file, OpenOption ... openOptions) {
        return (statusCode, responseHeaders) -> new FileCompleteListener(file, openOptions);
    }

    public static HttpResponse.BodyHandler<Path> asFile(Path file) {
        return BodyHandlers.asFile(file, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
    }

    public static HttpResponse.BodyHandler<byte[]> asByteArray() {
        return (statusCode, responseHeaders) -> new ByteArrayCompleteListener();
    }

    public static HttpResponse.BodyHandler<String> asString() {
        return new StringBodyHandler();
    }

    public static <U> HttpResponse.BodyHandler<U> discard(U value) {
        return (statusCode, responseHeaders) -> new DiscardBodyCompleteListener<Object>(value);
    }

    public static HttpResponse.BodyHandler<Void> discard() {
        return BodyHandlers.discard(null);
    }
}

