package de.mklinger.qetcher.client.model.v1.builder;

import de.mklinger.qetcher.client.model.v1.AvailableNode;
import de.mklinger.qetcher.client.model.v1.NodeAddress;
import de.mklinger.qetcher.client.model.v1.NodeLifecycle;
import de.mklinger.qetcher.client.model.v1.impl.AvailableNodeImpl;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class AvailableNodeBuilder {
	private String nodeId;
	private String nodeName;
	private NodeLifecycle nodeLifecycle;
	private NodeAddress address;

	public static AvailableNodeBuilder of(final AvailableNode availableNode) {
		return new AvailableNodeBuilder()
				.nodeId(availableNode.getNodeId())
				.nodeName(availableNode.getNodeName())
				.nodeLifecycle(availableNode.getNodeLifecycle())
				.address(availableNode.getAddress());
	}

	public String getNodeId() {
		return nodeId;
	}

	public AvailableNodeBuilder nodeId(final String nodeId) {
		this.nodeId = nodeId;
		return this;
	}

	public String getNodeName() {
		return nodeName;
	}

	public AvailableNodeBuilder nodeName(final String nodeName) {
		this.nodeName = nodeName;
		return this;
	}

	public NodeLifecycle getNodeLifecycle() {
		return nodeLifecycle;
	}

	public AvailableNodeBuilder nodeLifecycle(final NodeLifecycle nodeLifecycle) {
		this.nodeLifecycle = nodeLifecycle;
		return this;
	}

	public NodeAddress getAddress() {
		return address;
	}

	public AvailableNodeBuilder address(final NodeAddress address) {
		this.address = address;
		return this;
	}

	public AvailableNode build() {
		return new AvailableNodeImpl(this);
	}
}
