package de.mklinger.qetcher.client.model.v1;

import de.mklinger.qetcher.client.model.v1.builder.AvailabilityBuilder;
import de.mklinger.qetcher.client.model.v1.builder.AvailableConversionBuilder;
import de.mklinger.qetcher.client.model.v1.builder.ConversionBuilder;
import de.mklinger.qetcher.client.model.v1.builder.ConversionFileBuilder;
import de.mklinger.qetcher.client.model.v1.builder.ErrorBuilder;
import de.mklinger.qetcher.client.model.v1.builder.JobBuilder;
import de.mklinger.qetcher.client.model.v1.builder.NodeAddressBuilder;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class Builders {
	public static NodeAddressBuilder nodeAddress() {
		return new NodeAddressBuilder();
	}

	public static ConversionBuilder conversion() {
		return new ConversionBuilder();
	}

	public static ConversionBuilder conversion(final Conversion conversion) {
		return ConversionBuilder.of(conversion);
	}

	public static AvailableConversionBuilder availableConversion() {
		return new AvailableConversionBuilder();
	}

	public static AvailableConversionBuilder availableConversion(final AvailableConversion availableConversion) {
		return AvailableConversionBuilder.of(availableConversion);
	}

	public static AvailabilityBuilder availability() {
		return new AvailabilityBuilder();
	}

	public static ConversionFileBuilder conversionFile() {
		return new ConversionFileBuilder();
	}

	public static ConversionFileBuilder conversionFile(final ConversionFile conversionFile) {
		return ConversionFileBuilder.of(conversionFile);
	}

	public static JobBuilder job() {
		return new JobBuilder();
	}

	public static JobBuilder job(final Job job) {
		return JobBuilder.of(job);
	}

	public static ErrorBuilder error() {
		return new ErrorBuilder();
	}

	public static ErrorBuilder error(final Error error) {
		return ErrorBuilder.of(error);
	}
}
