/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.model.v1.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.mklinger.qetcher.client.model.v1.BuilderClasses;
import de.mklinger.qetcher.client.model.v1.jackson.ObjectMapperConfigurer;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class JsonTest {
    private static final Logger LOG = LoggerFactory.getLogger(JsonTest.class);
    private final Class<?> builderClass;

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> data() {
        return BuilderClasses.asTestParameters();
    }

    public JsonTest(Class<?> builderClass, String description) {
        this.builderClass = builderClass;
    }

    @Test
    public void test() throws ReflectiveOperationException, IOException {
        BuilderClasses.TestInstanceBag builderBag = BuilderClasses.newTestInstance(this.builderClass);
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectMapperConfigurer.configure((ObjectMapper)objectMapper);
        String json = objectMapper.writeValueAsString(builderBag.getBuiltInstance());
        LOG.debug(json);
        for (Map.Entry<String, Object> e : builderBag.getTestValues().entrySet()) {
            String propertyName = e.getKey();
            Object testValue = e.getValue();
            if (testValue instanceof String) {
                Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"" + propertyName + "\":\"" + testValue + "\"")));
                continue;
            }
            Assert.assertThat((Object)json, (Matcher)Matchers.containsString((String)("\"" + propertyName + "\":")));
        }
        Object readValue = objectMapper.readValue(json, builderBag.getBuiltType());
        Assert.assertThat((Object)readValue, (Matcher)Matchers.notNullValue());
        for (Map.Entry<String, Object> e : builderBag.getTestValues().entrySet()) {
            String propertyName = e.getKey();
            Object testValue = e.getValue();
            if (!(testValue instanceof String)) continue;
            Method getter = builderBag.getBuiltInstanceGetter(propertyName);
            Object actualValue = getter.invoke(readValue, new Object[0]);
            Assert.assertThat((Object)actualValue, (Matcher)Matchers.is((Object)testValue));
        }
    }
}

