package de.mklinger.qetcher.client.model.v1.jackson;

import java.io.IOException;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;

import de.mklinger.micro.mediatype.MediaType;
import de.mklinger.qetcher.client.model.v1.Availability;
import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.Conversion;
import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.Error;
import de.mklinger.qetcher.client.model.v1.Job;
import de.mklinger.qetcher.client.model.v1.NodeAddress;
import de.mklinger.qetcher.client.model.v1.impl.AvailabilityImpl;
import de.mklinger.qetcher.client.model.v1.impl.AvailableConversionImpl;
import de.mklinger.qetcher.client.model.v1.impl.ConversionFileImpl;
import de.mklinger.qetcher.client.model.v1.impl.ConversionImpl;
import de.mklinger.qetcher.client.model.v1.impl.ErrorImpl;
import de.mklinger.qetcher.client.model.v1.impl.JobImpl;
import de.mklinger.qetcher.client.model.v1.impl.NodeAddressImpl;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class ObjectMapperConfigurer {
	public static ObjectMapper configure(final ObjectMapper objectMapper) {
		objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
		objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
		objectMapper.registerModule(new JavaTimeModule());
		objectMapper.registerModule(new QetcherModelV1JacksonModule());
		return objectMapper;
	}

	private static class QetcherModelV1JacksonModule extends SimpleModule {
		private static final long serialVersionUID = 1L;

		public QetcherModelV1JacksonModule() {
			addSerializer(new JacksonMediaTypeSerializer());
			addDeserializer(MediaType.class, new JacksonMediaTypeDeserializer());

			addAbstractTypeMapping(NodeAddress.class, NodeAddressImpl.class);
			addAbstractTypeMapping(AvailableConversion.class, AvailableConversionImpl.class);
			addAbstractTypeMapping(Availability.class, AvailabilityImpl.class);
			addAbstractTypeMapping(Conversion.class, ConversionImpl.class);
			addAbstractTypeMapping(Job.class, JobImpl.class);
			addAbstractTypeMapping(ConversionFile.class, ConversionFileImpl.class);
			addAbstractTypeMapping(Error.class, ErrorImpl.class);
		}

		@Override
		public void setupModule(final SetupContext context) {
			context.insertAnnotationIntrospector(new QetcherJacksonAnnotationIntrospector());
			super.setupModule(context);
		}
	}

	private static class JacksonMediaTypeSerializer extends StdSerializer<MediaType> {
		private static final long serialVersionUID = 1L;

		public JacksonMediaTypeSerializer() {
			super(MediaType.class);
		}

		@Override
		public void serialize(final MediaType value, final JsonGenerator gen, final SerializerProvider provider) throws IOException {
			gen.writeString(value.toString());
		}
	}

	private static class JacksonMediaTypeDeserializer extends StdDeserializer<MediaType> {
		private static final long serialVersionUID = 1L;

		public JacksonMediaTypeDeserializer() {
			super(MediaType.class);
		}

		@Override
		public MediaType deserialize(final JsonParser p, final DeserializationContext ctxt) throws IOException {
			return MediaType.valueOf(p.getText());
		}
	}
}
