/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.model.v1.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.mklinger.qetcher.client.model.v1.Availability;
import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.Conversion;
import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.Error;
import de.mklinger.qetcher.client.model.v1.Job;
import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.client.model.v1.NodeAddress;
import de.mklinger.qetcher.client.model.v1.impl.AvailabilityImpl;
import de.mklinger.qetcher.client.model.v1.impl.AvailableConversionImpl;
import de.mklinger.qetcher.client.model.v1.impl.ConversionFileImpl;
import de.mklinger.qetcher.client.model.v1.impl.ConversionImpl;
import de.mklinger.qetcher.client.model.v1.impl.ErrorImpl;
import de.mklinger.qetcher.client.model.v1.impl.JobImpl;
import de.mklinger.qetcher.client.model.v1.impl.NodeAddressImpl;
import de.mklinger.qetcher.client.model.v1.jackson.QetcherJacksonAnnotationIntrospector;
import java.io.IOException;

public class ObjectMapperConfigurer {
    public static ObjectMapper configure(ObjectMapper objectMapper) {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new QetcherModelV1JacksonModule());
        return objectMapper;
    }

    private static class JacksonMediaTypeDeserializer
    extends StdDeserializer<MediaType> {
        private static final long serialVersionUID = 1L;

        public JacksonMediaTypeDeserializer() {
            super(MediaType.class);
        }

        public MediaType deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return MediaType.valueOf((String)p.getText());
        }
    }

    private static class JacksonMediaTypeSerializer
    extends StdSerializer<MediaType> {
        private static final long serialVersionUID = 1L;

        public JacksonMediaTypeSerializer() {
            super(MediaType.class);
        }

        public void serialize(MediaType value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.toString());
        }
    }

    private static class QetcherModelV1JacksonModule
    extends SimpleModule {
        private static final long serialVersionUID = 1L;

        public QetcherModelV1JacksonModule() {
            this.addSerializer((JsonSerializer)new JacksonMediaTypeSerializer());
            this.addDeserializer(MediaType.class, (JsonDeserializer)new JacksonMediaTypeDeserializer());
            this.addAbstractTypeMapping(NodeAddress.class, NodeAddressImpl.class);
            this.addAbstractTypeMapping(AvailableConversion.class, AvailableConversionImpl.class);
            this.addAbstractTypeMapping(Availability.class, AvailabilityImpl.class);
            this.addAbstractTypeMapping(Conversion.class, ConversionImpl.class);
            this.addAbstractTypeMapping(Job.class, JobImpl.class);
            this.addAbstractTypeMapping(ConversionFile.class, ConversionFileImpl.class);
            this.addAbstractTypeMapping(Error.class, ErrorImpl.class);
        }

        public void setupModule(Module.SetupContext context) {
            context.insertAnnotationIntrospector((AnnotationIntrospector)new QetcherJacksonAnnotationIntrospector());
            super.setupModule(context);
        }
    }
}

