/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.model.v1.impl;

import de.mklinger.micro.lists.Lists;
import de.mklinger.qetcher.client.model.v1.Availability;
import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.Conversion;
import de.mklinger.qetcher.client.model.v1.ModelValidationException;
import de.mklinger.qetcher.client.model.v1.builder.AvailableConversionBuilder;
import java.util.List;
import java.util.Objects;

public class AvailableConversionImpl
implements AvailableConversion {
    private final List<Availability> availabilities;
    private final Conversion conversion;

    public AvailableConversionImpl(AvailableConversionBuilder builder) {
        this.availabilities = Lists.newImmutableList(builder.getAvailabilities());
        this.conversion = builder.getConversion();
        try {
            this.validate();
        }
        catch (Exception e) {
            throw new ModelValidationException(AvailableConversion.class, (Throwable)e);
        }
    }

    private void validate() {
        Objects.requireNonNull(this.availabilities);
        if (this.availabilities.isEmpty()) {
            throw new IllegalArgumentException("Availabilities must not be empty");
        }
        Objects.requireNonNull(this.conversion);
    }

    @Override
    public List<Availability> getAvailabilities() {
        return this.availabilities;
    }

    @Override
    public Conversion getConversion() {
        return this.conversion;
    }
}

