package de.mklinger.qetcher.client.model.v1.impl;

import java.util.Objects;

import de.mklinger.qetcher.client.model.v1.JobPatch;
import de.mklinger.qetcher.client.model.v1.JobState;
import de.mklinger.qetcher.client.model.v1.builder.JobPatchBuilder;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class JobPatchImpl implements JobPatch {
	private final JobState state;

	public JobPatchImpl(JobPatchBuilder jobPatchBuilder) {
		this.state = jobPatchBuilder.getState();

		Objects.requireNonNull(state, "Missing state");
	}

	@Override
	public JobState getState() {
		return state;
	}
}
