package de.mklinger.qetcher.client.model.v1.impl;

import java.util.List;

import de.mklinger.micro.lists.Lists;
import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.AvailableConversions;
import de.mklinger.qetcher.client.model.v1.builder.AvailableConversionsBuilder;

/**
 * Available conversions on the cluster.
 *
 * This model class is not used internally, but only in v1 REST service and
 * Qetcher client.
 *
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class AvailableConversionsImpl implements AvailableConversions {
	private final List<AvailableConversion> availableConversions;

	public AvailableConversionsImpl(final AvailableConversionsBuilder builder) {
		this.availableConversions = Lists.newImmutableList(builder.getAvailableConversions());
	}

	@Override
	public List<AvailableConversion> getAvailableConversions() {
		return availableConversions;
	}
}
