package de.mklinger.qetcher.client.model.v1;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public enum NodeLifecycle {
	/** Indicates the node is starting. */
	NODE_STARTING,
	/** The node is up, but there are converters in error state. */
	PARTIALLY_FUNCTIONAL,
	/** Everything is running perfectly fine. */
	FULLY_FUNCTIONAL,
	/** Indicates the node prepares for stopping in the near future. */
	PREPARE_STOPPING,
	/** Indicates the node is ready for stopping. */
	READY_FOR_STOPPING,
	/** Indicates the node is stopping. */
	NODE_STOPPING;

	/**
	 * Return <code>true</code> if this state is fully or partially functional.
	 */
	public boolean isFunctional() {
		return this == FULLY_FUNCTIONAL
				|| this == PARTIALLY_FUNCTIONAL;
	}

	/**
	 * Return <code>true</code> if this state is related to stopping the node.
	 */
	public boolean isStopping() {
		return this == PREPARE_STOPPING
				|| this == READY_FOR_STOPPING
				|| this == NODE_STOPPING;
	}
}
