package de.mklinger.qetcher.client.model.v1;

import java.util.Map;
import java.util.Optional;

import de.mklinger.qetcher.client.model.v1.MediaType;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class FileExtensionInfos {
	private Map<String, MediaType> entries;

	public FileExtensionInfos(final Map<String, MediaType> entries) {
		this.entries = entries;
	}

	public FileExtensionInfos() {
	}

	public Map<String, MediaType> getEntries() {
		return entries;
	}

	public void setEntries(final Map<String, MediaType> entries) {
		this.entries = entries;
	}

	public Optional<MediaType> getMediaType(final String fileExtension) {
		MediaType mediaType = entries.get(fileExtension);
		if (mediaType == null) {
			mediaType = entries.get(fileExtension.toLowerCase());
		}
		return Optional.ofNullable(mediaType);
	}
}
