/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.model.v1;

import de.mklinger.qetcher.client.model.v1.Builders;
import de.mklinger.qetcher.client.model.v1.NodeAddress;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class NodeAddressBuilderTest {
    @Test(expected=IllegalArgumentException.class)
    public void illegalTest1() {
        Builders.nodeAddress().address("noport").build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void illegalTest2() {
        Builders.nodeAddress().address("invalidport:bla").build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void illegalTest3() {
        Builders.nodeAddress().address("invalidport:-1").build();
    }

    @Test
    public void nameTest() {
        NodeAddress nodeAddress = Builders.nodeAddress().address("qetcher.de:80").build();
        Assert.assertThat((Object)nodeAddress.getHost(), (Matcher)Matchers.is((Object)"qetcher.de"));
        Assert.assertThat((Object)nodeAddress.getPort(), (Matcher)Matchers.is((Object)80));
        Assert.assertThat((Object)nodeAddress.toHostUriString(), (Matcher)Matchers.is((Object)"qetcher.de"));
        Assert.assertThat((Object)nodeAddress.toUriString(), (Matcher)Matchers.is((Object)"qetcher.de:80"));
    }

    @Test
    public void ipv4Test() {
        NodeAddress nodeAddress = Builders.nodeAddress().address("127.0.0.1:80").build();
        Assert.assertThat((Object)nodeAddress.getHost(), (Matcher)Matchers.is((Object)"127.0.0.1"));
        Assert.assertThat((Object)nodeAddress.getPort(), (Matcher)Matchers.is((Object)80));
        Assert.assertThat((Object)nodeAddress.toHostUriString(), (Matcher)Matchers.is((Object)"127.0.0.1"));
        Assert.assertThat((Object)nodeAddress.toUriString(), (Matcher)Matchers.is((Object)"127.0.0.1:80"));
    }

    @Test
    public void ipv6Test() {
        NodeAddress nodeAddress = Builders.nodeAddress().address("[::1]:80").build();
        Assert.assertThat((Object)nodeAddress.getHost(), (Matcher)Matchers.is((Object)"::1"));
        Assert.assertThat((Object)nodeAddress.getPort(), (Matcher)Matchers.is((Object)80));
        Assert.assertThat((Object)nodeAddress.toHostUriString(), (Matcher)Matchers.is((Object)"[::1]"));
        Assert.assertThat((Object)nodeAddress.toUriString(), (Matcher)Matchers.is((Object)"[::1]:80"));
    }

    @Test
    public void ipv6Test2() {
        NodeAddress nodeAddress = Builders.nodeAddress().address("::1:80").build();
        Assert.assertThat((Object)nodeAddress.getHost(), (Matcher)Matchers.is((Object)"::1"));
        Assert.assertThat((Object)nodeAddress.getPort(), (Matcher)Matchers.is((Object)80));
        Assert.assertThat((Object)nodeAddress.toHostUriString(), (Matcher)Matchers.is((Object)"[::1]"));
        Assert.assertThat((Object)nodeAddress.toUriString(), (Matcher)Matchers.is((Object)"[::1]:80"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void ipv6IllegalTest1() {
        Builders.nodeAddress().address("[::1").build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void ipv6IllegalTest2() {
        Builders.nodeAddress().address("[::1:80").build();
    }
}

