/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.model.v1;

import de.mklinger.qetcher.client.model.v1.BuilderClasses;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BuilderTest {
    private final Class<?> builderClass;

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> data() {
        return BuilderClasses.asTestParameters();
    }

    public BuilderTest(Class<?> builderClass, String description) {
        this.builderClass = builderClass;
    }

    @Test
    public void test() throws ReflectiveOperationException {
        BuilderClasses.TestInstanceBag builderBag = BuilderClasses.newTestInstance(this.builderClass);
        for (Map.Entry<String, Type> e : builderBag.getPropertyTypes().entrySet()) {
            String propertyName = e.getKey();
            Object testValue = builderBag.getTestValues().get(propertyName);
            Method getter = builderBag.getBuiltInstanceGetter(propertyName);
            Object verifyValue = getter.invoke(builderBag.getBuiltInstance(), new Object[0]);
            Assert.assertEquals((String)("Property '" + propertyName + "' in built object:"), (Object)testValue, (Object)verifyValue);
        }
        Method ofMethod = this.builderClass.getMethod("of", builderBag.getBuiltType());
        Object builderFromBuilded = ofMethod.invoke(null, builderBag.getBuiltInstance());
        for (Map.Entry<String, Type> e : builderBag.getPropertyTypes().entrySet()) {
            String propertyName = e.getKey();
            if ("updated".equals(propertyName)) continue;
            Object testValue = builderBag.getTestValues().get(propertyName);
            Method getter = builderBag.getBuilderInstanceGetter(propertyName);
            Object verifyValue = getter.invoke(builderFromBuilded, new Object[0]);
            Assert.assertEquals((String)("Property '" + propertyName + "' in builder from built object:"), (Object)testValue, (Object)verifyValue);
        }
    }
}

