/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.model.v1;

import de.mklinger.qetcher.client.model.v1.Builders;
import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.Job;
import de.mklinger.qetcher.client.model.v1.JobState;
import de.mklinger.qetcher.client.model.v1.MediaType;
import de.mklinger.qetcher.client.model.v1.MediaTypes;
import de.mklinger.qetcher.client.model.v1.builder.AvailabilityBuilder;
import de.mklinger.qetcher.client.model.v1.builder.AvailableConversionBuilder;
import de.mklinger.qetcher.client.model.v1.builder.AvailableConversionsBuilder;
import de.mklinger.qetcher.client.model.v1.builder.AvailableNodeBuilder;
import de.mklinger.qetcher.client.model.v1.builder.AvailableNodesBuilder;
import de.mklinger.qetcher.client.model.v1.builder.ConversionBuilder;
import de.mklinger.qetcher.client.model.v1.builder.ConversionFileBuilder;
import de.mklinger.qetcher.client.model.v1.builder.ConversionFilesBuilder;
import de.mklinger.qetcher.client.model.v1.builder.ErrorBuilder;
import de.mklinger.qetcher.client.model.v1.builder.JobBuilder;
import de.mklinger.qetcher.client.model.v1.builder.JobsBuilder;
import de.mklinger.qetcher.client.model.v1.builder.NodeAddressBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import org.junit.Assert;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuilderClasses {
    private static final Logger LOG = LoggerFactory.getLogger(BuilderClasses.class);
    private static final Class<?>[] BUILDER_CLASSES = new Class[]{AvailabilityBuilder.class, AvailableConversionBuilder.class, AvailableConversionsBuilder.class, AvailableNodeBuilder.class, AvailableNodesBuilder.class, ConversionBuilder.class, ConversionFileBuilder.class, ConversionFilesBuilder.class, ErrorBuilder.class, JobBuilder.class, JobsBuilder.class, NodeAddressBuilder.class};
    private static final ConversionFile testConversionFile = Builders.conversionFile().fileId("file-0").tenantId("tenant-0").created(Instant.now()).updated(Instant.now()).mediaType(MediaTypes.PDF).size(BigInteger.valueOf(15000L)).withNodeId("node-0").build();
    private static final Job testJob = Builders.job().jobId("job-0").tenantId("tenant-0").created(Instant.now()).updated(Instant.now()).withInputFileId(testConversionFile.getFileId()).fromMediaType(MediaTypes.PDF).toMediaType(MediaTypes.TXT).state(JobState.WAITING).build();
    private static long nextTestValue = 0L;

    public static Stream<Class<?>> stream() {
        return Arrays.stream(BUILDER_CLASSES);
    }

    /*
     * Exception decompiling
     */
    public static Iterable<Object[]> asTestParameters() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Object describe(Class<?> clazz) {
        return clazz.getSimpleName();
    }

    public static <BuilderT, BuiltT> TestInstanceBag<BuilderT, BuiltT> newTestInstance(Class<BuilderT> builderClass) throws ReflectiveOperationException {
        Type type;
        HashMap<String, Type> propertyTypes = new HashMap<String, Type>();
        BuilderT builder = builderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        for (Field field : builder.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            type = field.getGenericType();
            propertyTypes.put(field.getName(), type);
        }
        HashMap<String, Object> testValues = new HashMap<String, Object>();
        for (Map.Entry e : propertyTypes.entrySet()) {
            Cloneable testValue;
            Class clazz;
            String propertyName = (String)e.getKey();
            type = (Type)e.getValue();
            if (type instanceof ParameterizedType) {
                int i;
                int size;
                AbstractCollection l;
                ParameterizedType pt = (ParameterizedType)type;
                clazz = (Class)pt.getRawType();
                if (List.class.isAssignableFrom(clazz)) {
                    Assert.assertTrue((String)("Type: " + type), (List.class == clazz ? 1 : 0) != 0);
                    l = new ArrayList();
                    size = ThreadLocalRandom.current().nextInt(3) + 1;
                    for (i = 0; i < size; ++i) {
                        ((ArrayList)l).add(BuilderClasses.getTestValue(propertyName, (Class)pt.getActualTypeArguments()[0]));
                    }
                    testValue = l;
                } else if (Set.class.isAssignableFrom(clazz)) {
                    Assert.assertTrue((String)("Type: " + type), (Set.class == clazz ? 1 : 0) != 0);
                    l = new HashSet();
                    size = ThreadLocalRandom.current().nextInt(3) + 1;
                    for (i = 0; i < size; ++i) {
                        ((HashSet)l).add(BuilderClasses.getTestValue(propertyName, (Class)pt.getActualTypeArguments()[0]));
                    }
                    testValue = l;
                } else if (Map.class.isAssignableFrom(clazz)) {
                    Assert.assertTrue((String)("Type: " + type), (Map.class == clazz ? 1 : 0) != 0);
                    HashMap<Object, Object> m = new HashMap<Object, Object>();
                    size = ThreadLocalRandom.current().nextInt(3) + 1;
                    for (i = 0; i < size; ++i) {
                        m.put(BuilderClasses.getTestValue(propertyName, (Class)pt.getActualTypeArguments()[0]), BuilderClasses.getTestValue(propertyName, (Class)pt.getActualTypeArguments()[1]));
                    }
                    testValue = m;
                } else {
                    Assert.fail((String)("NYI: " + type));
                    testValue = null;
                }
            } else {
                clazz = (Class)type;
                testValue = BuilderClasses.getTestValue(propertyName, clazz);
            }
            testValues.put(propertyName, testValue);
            BuilderClasses.setValue(builder, propertyName, clazz, testValue);
        }
        Method buildMethod = builderClass.getMethod("build", new Class[0]);
        Class<?> builtType = buildMethod.getReturnType();
        Object builtInstance = buildMethod.invoke(builder, new Object[0]);
        return new TestInstanceBag<BuilderT, Object>(builderClass, builder, propertyTypes, testValues, builtType, builtInstance);
    }

    private static void setValue(Object builder, String propertyName, Class<?> propertyType, Object value) throws ReflectiveOperationException {
        builder.getClass().getMethod(propertyName, propertyType).invoke(builder, value);
    }

    private static Object getTestValue(String propertyName, Class<?> clazz) throws ReflectiveOperationException {
        if ("clusterId".equals(propertyName)) {
            return "cluster-id";
        }
        if (clazz.isEnum()) {
            ?[] constants = clazz.getEnumConstants();
            return constants[(int)(++nextTestValue) % constants.length];
        }
        if (clazz == String.class) {
            return "str" + BuilderClasses.getTestValue(propertyName, Long.class);
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return ++nextTestValue % 2L == 0L;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return (int)(++nextTestValue);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return ++nextTestValue;
        }
        if (clazz == Duration.class) {
            return Duration.ofHours(++nextTestValue);
        }
        if (clazz == Instant.class) {
            ++nextTestValue;
            return Instant.now();
        }
        if (clazz == OffsetDateTime.class) {
            return OffsetDateTime.ofInstant(new Date(++nextTestValue).toInstant(), ZoneId.of("Z"));
        }
        if (clazz == BigInteger.class) {
            return BigInteger.valueOf(nextTestValue++);
        }
        if (clazz == MediaType.class) {
            long v = nextTestValue++;
            return new MediaType("application", "x-" + v);
        }
        if (clazz == Job.class) {
            return testJob;
        }
        if (clazz == ConversionFile.class) {
            return testConversionFile;
        }
        if (clazz.getPackage().equals(Job.class.getPackage())) {
            String builderClassName = JobBuilder.class.getPackage().getName() + "." + clazz.getSimpleName() + "Builder";
            Class<?> builderClass = Class.forName(builderClassName);
            return BuilderClasses.newTestInstance(builderClass).getBuiltInstance();
        }
        LOG.warn("Producing pure mock for {}", clazz);
        Object o = Mockito.mock(clazz);
        return o;
    }

    public static class TestInstanceBag<BuiderT, BuiltT> {
        private final Class<BuiderT> builderClass;
        private final BuiderT builderInstance;
        private final Map<String, Type> propertyTypes;
        private final Map<String, Object> testValues;
        private final Class<BuiltT> builtType;
        private final BuiltT builtInstance;

        public TestInstanceBag(Class<BuiderT> builderClass, BuiderT builderInstance, Map<String, Type> propertyTypes, Map<String, Object> testValues, Class<BuiltT> builtType, BuiltT builtInstance) {
            this.builderClass = builderClass;
            this.builderInstance = builderInstance;
            this.propertyTypes = propertyTypes;
            this.testValues = testValues;
            this.builtType = builtType;
            this.builtInstance = builtInstance;
        }

        public Class<BuiderT> getBuilderClass() {
            return this.builderClass;
        }

        public BuiderT getBuilderInstance() {
            return this.builderInstance;
        }

        public Map<String, Type> getPropertyTypes() {
            return this.propertyTypes;
        }

        public Map<String, Object> getTestValues() {
            return this.testValues;
        }

        public Class<BuiltT> getBuiltType() {
            return this.builtType;
        }

        public BuiltT getBuiltInstance() {
            return this.builtInstance;
        }

        public Method getBuilderInstanceGetter(String propertyName) throws NoSuchMethodException {
            return TestInstanceBag.getGetter(this.builderInstance, propertyName);
        }

        public Method getBuiltInstanceGetter(String propertyName) throws NoSuchMethodException {
            return TestInstanceBag.getGetter(this.builtInstance, propertyName);
        }

        private static Method getGetter(Object o, String propertyName) throws NoSuchMethodException {
            String methodNameSuffix = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
            try {
                return o.getClass().getMethod("get" + methodNameSuffix, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    return o.getClass().getMethod("is" + methodNameSuffix, new Class[0]);
                }
                catch (NoSuchMethodException e2) {
                    e.addSuppressed(e2);
                    throw e;
                }
            }
        }
    }
}

