package de.mklinger.qetcher.client.model.v1.jackson.xml;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class ObjectMapperConfigurer {
	public static ObjectMapper configure(final ObjectMapper objectMapper) {
		de.mklinger.qetcher.client.model.v1.jackson.ObjectMapperConfigurer.configure(objectMapper);

		if (objectMapper instanceof XmlMapper) {
			final XmlMapper xmlMapper = (XmlMapper) objectMapper;
			xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
			xmlMapper.setDefaultUseWrapper(false);
			xmlMapper.registerModule(new QetcherModelV1JacksonXmlModule());
		}

		return objectMapper;
	}

	private static class QetcherModelV1JacksonXmlModule extends JacksonXmlModule {
		private static final long serialVersionUID = 1L;

		@Override
		protected AnnotationIntrospector _constructIntrospector() {
			return new QetcherJacksonXmlAnnotationIntrospector();
		}
	}
}
