/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.model.v1.jackson.xml;

import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlAnnotationIntrospector;
import java.util.Collection;

public class QetcherJacksonXmlAnnotationIntrospector
extends JacksonXmlAnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    private static final String QETCHER_NAMESPACE = "http://mklinger.de/xml/qetcher";

    public QetcherJacksonXmlAnnotationIntrospector() {
        super(false);
    }

    public PropertyName findRootName(AnnotatedClass ac) {
        PropertyName rootName = super.findRootName(ac);
        if (rootName == null) {
            String localName = ac.getRawType().getSimpleName();
            if (localName.length() > 1) {
                localName = localName.substring(0, 1).toLowerCase() + localName.substring(1);
            }
            if (localName.length() > "Impl".length() && localName.endsWith("Impl")) {
                localName = localName.substring(0, localName.length() - "Impl".length());
            }
            rootName = PropertyName.construct((String)localName, (String)QETCHER_NAMESPACE);
        }
        return rootName;
    }

    public String findNamespace(Annotated ann) {
        String namespace = super.findNamespace(ann);
        if (namespace == null) {
            namespace = QETCHER_NAMESPACE;
        }
        return namespace;
    }

    public Object findNamingStrategy(AnnotatedClass ac) {
        return new PropertyNamingStrategy(){
            private static final long serialVersionUID = 1L;

            public String nameForField(MapperConfig<?> config, AnnotatedField field, String defaultName) {
                if (this.isPlural(field.getRawType(), defaultName)) {
                    return this.getSingular(defaultName);
                }
                return super.nameForField(config, field, defaultName);
            }

            public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
                if (this.isPlural(method.getRawReturnType(), defaultName)) {
                    return this.getSingular(defaultName);
                }
                return super.nameForGetterMethod(config, method, defaultName);
            }

            public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
                if (this.isPlural(method.getRawParameterType(0), defaultName)) {
                    return this.getSingular(defaultName);
                }
                return super.nameForSetterMethod(config, method, defaultName);
            }

            private boolean isPlural(Class<?> clazz, String defaultName) {
                return this.isCollection(clazz) && defaultName.length() > 1 && defaultName.endsWith("s");
            }

            private String getSingular(String defaultName) {
                if (defaultName.endsWith("ies")) {
                    return defaultName.substring(0, defaultName.length() - 3) + "y";
                }
                return defaultName.substring(0, defaultName.length() - 1);
            }

            private boolean isCollection(Class<?> clazz) {
                return Collection.class.isAssignableFrom(clazz) || clazz.isArray();
            }
        };
    }
}

