/*
 * Decompiled with CFR 0.152.
 */
package org.conscrypt;

import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSessionContext;
import org.conscrypt.ConscryptSession;
import org.conscrypt.SessionDecorator;

class Java7ExtendedSSLSession
extends ExtendedSSLSession
implements SessionDecorator {
    private static final String[] LOCAL_SUPPORTED_SIGNATURE_ALGORITHMS = new String[]{"SHA512withRSA", "SHA512withECDSA", "SHA384withRSA", "SHA384withECDSA", "SHA256withRSA", "SHA256withECDSA", "SHA224withRSA", "SHA224withECDSA", "SHA1withRSA", "SHA1withECDSA"};
    private static final String[] PEER_SUPPORTED_SIGNATURE_ALGORITHMS = new String[]{"SHA1withRSA", "SHA1withECDSA"};
    private final ConscryptSession delegate;

    Java7ExtendedSSLSession(ConscryptSession delegate) {
        this.delegate = delegate;
    }

    @Override
    public final ConscryptSession getDelegate() {
        return this.delegate;
    }

    @Override
    public final String[] getLocalSupportedSignatureAlgorithms() {
        return (String[])LOCAL_SUPPORTED_SIGNATURE_ALGORITHMS.clone();
    }

    @Override
    public final String[] getPeerSupportedSignatureAlgorithms() {
        return (String[])PEER_SUPPORTED_SIGNATURE_ALGORITHMS.clone();
    }

    @Override
    public final String getRequestedServerName() {
        return this.getDelegate().getRequestedServerName();
    }

    @Override
    public final List<byte[]> getStatusResponses() {
        return this.getDelegate().getStatusResponses();
    }

    @Override
    public final byte[] getPeerSignedCertificateTimestamp() {
        return this.getDelegate().getPeerSignedCertificateTimestamp();
    }

    @Override
    public final byte[] getId() {
        return this.getDelegate().getId();
    }

    @Override
    public final SSLSessionContext getSessionContext() {
        return this.getDelegate().getSessionContext();
    }

    @Override
    public final long getCreationTime() {
        return this.getDelegate().getCreationTime();
    }

    @Override
    public final long getLastAccessedTime() {
        return this.getDelegate().getLastAccessedTime();
    }

    @Override
    public final void invalidate() {
        this.getDelegate().invalidate();
    }

    @Override
    public final boolean isValid() {
        return this.getDelegate().isValid();
    }

    @Override
    public final void putValue(String s, Object o) {
        this.getDelegate().putValue(s, o);
    }

    @Override
    public final Object getValue(String s) {
        return this.getDelegate().getValue(s);
    }

    @Override
    public final void removeValue(String s) {
        this.getDelegate().removeValue(s);
    }

    @Override
    public final String[] getValueNames() {
        return this.getDelegate().getValueNames();
    }

    @Override
    public X509Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        return this.getDelegate().getPeerCertificates();
    }

    @Override
    public final Certificate[] getLocalCertificates() {
        return this.getDelegate().getLocalCertificates();
    }

    @Override
    public final javax.security.cert.X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        return this.getDelegate().getPeerCertificateChain();
    }

    @Override
    public final Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        return this.getDelegate().getPeerPrincipal();
    }

    @Override
    public final Principal getLocalPrincipal() {
        return this.getDelegate().getLocalPrincipal();
    }

    @Override
    public final String getCipherSuite() {
        return this.getDelegate().getCipherSuite();
    }

    @Override
    public final String getProtocol() {
        return this.getDelegate().getProtocol();
    }

    @Override
    public final String getPeerHost() {
        return this.getDelegate().getPeerHost();
    }

    @Override
    public final int getPeerPort() {
        return this.getDelegate().getPeerPort();
    }

    @Override
    public final int getPacketBufferSize() {
        return this.getDelegate().getPacketBufferSize();
    }

    @Override
    public final int getApplicationBufferSize() {
        return this.getDelegate().getApplicationBufferSize();
    }
}

