/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.impl.lookup;

import de.mklinger.qetcher.client.QetcherClient;
import de.mklinger.qetcher.client.annotations.VisibleForTesting;
import de.mklinger.qetcher.client.common.concurrent.Delay;
import de.mklinger.qetcher.client.impl.lookup.NodesHolder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledNodesLookup
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledNodesLookup.class);
    private final QetcherClient client;
    private final NodesHolder nodesHolder;
    private final AtomicBoolean closed;

    public ScheduledNodesLookup(QetcherClient client, NodesHolder nodesHolder) {
        this.client = client;
        this.nodesHolder = nodesHolder;
        this.closed = new AtomicBoolean();
    }

    public void startDelayed() {
        this.execute(5L, 300L, TimeUnit.SECONDS);
    }

    @VisibleForTesting
    protected void execute(long initialDelay, long delay, TimeUnit unit) {
        Delay.delayedExecutor(initialDelay, unit).execute(() -> this.execute(delay, unit));
    }

    private void execute(long nextDelay, TimeUnit unit) {
        if (this.closed.get()) {
            return;
        }
        LOG.debug("Doing nodes lookup...");
        ((CompletableFuture)this.client.getAvailableNodes().thenAccept(this.nodesHolder::setNodes)).whenComplete((unused, error) -> {
            if (this.closed.get()) {
                return;
            }
            if (error != null) {
                LOG.warn("Error on nodes lookup: {}", (Object)error.getMessage());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Error on nodes lookup stack trace:", error);
                }
            } else {
                LOG.debug("Nodes lookup successful");
            }
            this.execute(nextDelay, nextDelay, unit);
        });
    }

    @Override
    public void close() {
        this.closed.set(true);
    }
}

