/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QetcherClientVersion {
    private static final Logger LOG = LoggerFactory.getLogger(QetcherClientVersion.class);
    private static final String VERSION_PROPERTIES = "version.properties";
    private static volatile String version;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getVersion() {
        if (version != null) return version;
        Class<QetcherClientVersion> clazz = QetcherClientVersion.class;
        synchronized (QetcherClientVersion.class) {
            if (version != null) return version;
            try (InputStream in = QetcherClientVersion.class.getResourceAsStream(VERSION_PROPERTIES);){
                Properties versionProperties = new Properties();
                versionProperties.load(in);
                version = versionProperties.getProperty("qetcher.client.version");
            }
            catch (Exception e) {
                LOG.error("Error loading version properties", (Throwable)e);
            }
            if (version != null) return version;
            version = "unknown-version";
            // ** MonitorExit[var0] (shouldn't be in output)
            return version;
        }
    }
}

