package de.mklinger.qetcher.client.impl;

import java.time.Duration;
import java.util.Objects;

import de.mklinger.qetcher.client.InputConversionFile;
import de.mklinger.qetcher.client.InputJob;
import de.mklinger.qetcher.client.model.v1.MediaType;

public class InputJobImpl implements InputJob {
	private final String conversionFileId;
	private final InputConversionFile inputConversionFile;
	private final MediaType toMediaType;
	private final MediaType fromMediaType;
	private final Duration deleteTimeout;
	private final Duration cancelTimeout;
	private final String referrer;

	public InputJobImpl(final InputJobBuilderImpl builder) {
		this.conversionFileId = builder.getConversionFileId();
		this.inputConversionFile = builder.getInputConversionFile();
		this.toMediaType = Objects.requireNonNull(builder.getToMediaType(), "Missing toMediaType");
		this.fromMediaType = builder.getFromMediaType();
		this.deleteTimeout = builder.getDeleteTimeout();
		this.cancelTimeout = builder.getCancelTimeout();
		this.referrer = builder.getReferrer();

		if ((this.conversionFileId == null && this.inputConversionFile == null)
				|| (this.conversionFileId != null && this.inputConversionFile != null)) {
			throw new IllegalArgumentException("Only one of conversionFileId and inputConversionFile must be set");
		}

		if (this.fromMediaType == null && this.inputConversionFile == null) {
			throw new IllegalArgumentException("fromMediaType must be given when inputConversionFile is not set");
		}
		if (this.fromMediaType != null && this.inputConversionFile != null) {
			throw new IllegalArgumentException("fromMediaType must not be given when inputConversionFile is set");
		}
	}

	@Override
	public String getConversionFileId() {
		return conversionFileId;
	}

	@Override
	public InputConversionFile getInputConversionFile() {
		return inputConversionFile;
	}

	@Override
	public MediaType getFromMediaType() {
		if (fromMediaType == null) {
			return inputConversionFile.getMediaType();
		} else {
			return fromMediaType;
		}
	}

	@Override
	public MediaType getToMediaType() {
		return toMediaType;
	}

	@Override
	public Duration getDeleteTimeout() {
		if (deleteTimeout == null && inputConversionFile != null) {
			return inputConversionFile.getDeleteTimeout();
		} else {
			return deleteTimeout;
		}
	}

	@Override
	public Duration getCancelTimeout() {
		return cancelTimeout;
	}

	@Override
	public String getReferrer() {
		return referrer;
	}
}