/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.model.v1.impl;

import de.mklinger.qetcher.client.lists.Lists;
import de.mklinger.qetcher.client.maps.Maps;
import de.mklinger.qetcher.client.mediatype.MediaType;
import de.mklinger.qetcher.client.model.v1.Error;
import de.mklinger.qetcher.client.model.v1.Job;
import de.mklinger.qetcher.client.model.v1.JobState;
import de.mklinger.qetcher.client.model.v1.ModelValidationException;
import de.mklinger.qetcher.client.model.v1.builder.JobBuilder;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class JobImpl
implements Job {
    private static final Pattern PROPERTY_KEY_PATTERN = Pattern.compile("[a-z_A-Z][a-z_A-Z\\-\\.0-9]*");
    private final String jobId;
    private final String parentJobId;
    private final String tenantId;
    private final String nodeId;
    private final String converterId;
    private final int priority;
    private final MediaType fromMediaType;
    private final List<String> inputFileIds;
    private final MediaType toMediaType;
    private final List<String> resultFileIds;
    private final JobState state;
    private final Error error;
    private final Map<String, String> properties;
    private final Instant created;
    private final Instant updated;
    private final Duration estimatedRunTime;
    private final String referrer;
    private final Duration cancelTimeout;
    private final Duration deleteTimeout;

    public JobImpl(JobBuilder builder) {
        this.jobId = builder.getJobId();
        this.parentJobId = builder.getParentJobId();
        this.tenantId = builder.getTenantId();
        this.nodeId = builder.getNodeId();
        this.converterId = builder.getConverterId();
        this.priority = builder.getPriority();
        this.fromMediaType = builder.getFromMediaType();
        this.inputFileIds = Lists.newImmutableList(builder.getInputFileIds());
        this.toMediaType = builder.getToMediaType();
        this.resultFileIds = Lists.newImmutableList(builder.getResultFileIds());
        this.state = builder.getState();
        this.error = builder.getError();
        this.properties = Maps.newImmutableMap(builder.getProperties());
        this.created = builder.getCreated();
        this.updated = builder.getUpdated() == null ? Instant.now() : builder.getUpdated();
        this.estimatedRunTime = builder.getEstimatedRunTime();
        this.referrer = builder.getReferrer();
        this.cancelTimeout = builder.getCancelTimeout();
        this.deleteTimeout = builder.getDeleteTimeout();
        try {
            this.validate();
        }
        catch (Exception e) {
            throw new ModelValidationException(Job.class, (Throwable)e);
        }
    }

    private void validate() {
        Objects.requireNonNull(this.jobId);
        Objects.requireNonNull(this.tenantId);
        Objects.requireNonNull(this.priority);
        Objects.requireNonNull(this.fromMediaType);
        Objects.requireNonNull(this.inputFileIds);
        if (this.inputFileIds.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Objects.requireNonNull(this.toMediaType);
        Objects.requireNonNull(this.resultFileIds);
        Objects.requireNonNull(this.state);
        Objects.requireNonNull(this.properties);
        Objects.requireNonNull(this.created);
        Objects.requireNonNull(this.updated);
        if (this.error == null && this.state == JobState.ERROR) {
            throw new IllegalArgumentException("Job state is error, but error is not set");
        }
        for (String propertyKey : this.properties.keySet()) {
            if (PROPERTY_KEY_PATTERN.matcher(propertyKey).matches()) continue;
            throw new IllegalArgumentException("Illegal property key. Property keys must match the regular expression " + PROPERTY_KEY_PATTERN.pattern());
        }
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public String getParentJobId() {
        return this.parentJobId;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public String getConverterId() {
        return this.converterId;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public MediaType getFromMediaType() {
        return this.fromMediaType;
    }

    @Override
    public List<String> getInputFileIds() {
        return this.inputFileIds;
    }

    @Override
    public MediaType getToMediaType() {
        return this.toMediaType;
    }

    @Override
    public List<String> getResultFileIds() {
        return this.resultFileIds;
    }

    @Override
    public JobState getState() {
        return this.state;
    }

    @Override
    public Error getError() {
        return this.error;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public Instant getCreated() {
        return this.created;
    }

    @Override
    public Instant getUpdated() {
        return this.updated;
    }

    @Override
    public Duration getEstimatedRunTime() {
        return this.estimatedRunTime;
    }

    @Override
    public String getReferrer() {
        return this.referrer;
    }

    @Override
    public Duration getCancelTimeout() {
        return this.cancelTimeout;
    }

    @Override
    public Duration getDeleteTimeout() {
        return this.deleteTimeout;
    }

    public String toString() {
        return "JobImpl{jobId='" + this.jobId + '\'' + ", parentJobId='" + this.parentJobId + '\'' + ", tenantId='" + this.tenantId + '\'' + ", nodeId='" + this.nodeId + '\'' + ", converterId='" + this.converterId + '\'' + ", priority=" + this.priority + ", fromMediaType=" + this.fromMediaType + ", toMediaType=" + this.toMediaType + ", state=" + (Object)((Object)this.state) + ", error=" + this.error + '}';
    }
}

