/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.model.v1.impl;

import de.mklinger.qetcher.client.lists.Lists;
import de.mklinger.qetcher.client.mediatype.MediaType;
import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.ModelValidationException;
import de.mklinger.qetcher.client.model.v1.builder.ConversionFileBuilder;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;

public class ConversionFileImpl
implements ConversionFile {
    private final String fileId;
    private final boolean serviceManaged;
    private final String tenantId;
    private final String name;
    private final BigInteger size;
    private final MediaType mediaType;
    private final List<String> nodeIds;
    private final Duration deleteTimeout;
    private final Instant created;
    private final Instant updated;

    public ConversionFileImpl(ConversionFileBuilder builder) {
        this.fileId = builder.getFileId();
        this.serviceManaged = builder.isServiceManaged();
        this.tenantId = builder.getTenantId();
        this.name = builder.getName();
        this.size = builder.getSize();
        this.mediaType = builder.getMediaType();
        this.nodeIds = Lists.newImmutableList(builder.getNodeIds());
        this.deleteTimeout = builder.getDeleteTimeout();
        this.created = builder.getCreated();
        this.updated = builder.getUpdated();
        try {
            this.validate();
        }
        catch (Exception e) {
            throw new ModelValidationException(ConversionFile.class, (Throwable)e);
        }
    }

    private void validate() {
        Objects.requireNonNull(this.fileId);
        Objects.requireNonNull(this.tenantId);
        Objects.requireNonNull(this.size);
        Objects.requireNonNull(this.mediaType);
        Objects.requireNonNull(this.nodeIds);
        if (this.nodeIds.isEmpty()) {
            throw new IllegalStateException("nodeIds must not be empty");
        }
        Objects.requireNonNull(this.created);
        Objects.requireNonNull(this.updated);
    }

    @Override
    public String getFileId() {
        return this.fileId;
    }

    @Override
    public boolean isServiceManaged() {
        return this.serviceManaged;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public BigInteger getSize() {
        return this.size;
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public List<String> getNodeIds() {
        return this.nodeIds;
    }

    @Override
    public Duration getDeleteTimeout() {
        return this.deleteTimeout;
    }

    @Override
    public Instant getCreated() {
        return this.created;
    }

    @Override
    public Instant getUpdated() {
        return this.updated;
    }

    public String toString() {
        return "ConversionFileImpl{fileId='" + this.fileId + '\'' + ", serviceManaged=" + this.serviceManaged + ", tenantId='" + this.tenantId + '\'' + ", name='" + this.name + '\'' + ", size=" + this.size + ", mediaType=" + this.mediaType + ", nodeIds=" + this.nodeIds + ", deleteTimeout=" + this.deleteTimeout + ", created=" + this.created + ", updated=" + this.updated + '}';
    }
}

