/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.model.v1.builder;

import de.mklinger.qetcher.client.mediatype.MediaType;
import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.Error;
import de.mklinger.qetcher.client.model.v1.Job;
import de.mklinger.qetcher.client.model.v1.JobState;
import de.mklinger.qetcher.client.model.v1.impl.JobImpl;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class JobBuilder {
    private String jobId;
    private String parentJobId;
    private String tenantId;
    private String nodeId;
    private String converterId;
    private int priority;
    private MediaType fromMediaType;
    private List<String> inputFileIds;
    private MediaType toMediaType;
    private List<String> resultFileIds;
    private JobState state;
    private Error error;
    private Map<String, String> properties;
    private Instant created;
    private Instant updated;
    private Duration estimatedRunTime;
    private String referrer;
    private Duration cancelTimeout;
    private Duration deleteTimeout;

    public static JobBuilder of(Job job) {
        return new JobBuilder().jobId(job.getJobId()).parentJobId(job.getParentJobId()).tenantId(job.getTenantId()).nodeId(job.getNodeId()).converterId(job.getConverterId()).priority(job.getPriority()).fromMediaType(job.getFromMediaType()).inputFileIds(job.getInputFileIds()).toMediaType(job.getToMediaType()).resultFileIds(job.getResultFileIds()).error(job.getError()).state(job.getState()).properties(job.getProperties()).created(job.getCreated()).updated(Instant.now()).estimatedRunTime(job.getEstimatedRunTime()).referrer(job.getReferrer()).cancelTimeout(job.getCancelTimeout()).deleteTimeout(job.getDeleteTimeout());
    }

    public JobBuilder jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    public JobBuilder parentJobId(String parentJobId) {
        this.parentJobId = parentJobId;
        return this;
    }

    public JobBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public JobBuilder nodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public JobBuilder converterId(String converterId) {
        this.converterId = converterId;
        return this;
    }

    public JobBuilder priority(int priority) {
        this.priority = priority;
        return this;
    }

    public JobBuilder fromMediaType(MediaType fromMediaType) {
        this.fromMediaType = fromMediaType;
        return this;
    }

    public JobBuilder inputFiles(List<ConversionFile> inputFiles) {
        if (inputFiles == null || inputFiles.isEmpty()) {
            return this.inputFileIds(null);
        }
        if (this.inputFileIds == null || this.inputFileIds.isEmpty()) {
            this.fromMediaType(inputFiles.get(0).getMediaType());
        }
        return this.inputFileIds(inputFiles.stream().map(ConversionFile::getFileId).collect(Collectors.toList()));
    }

    public JobBuilder inputFileIds(List<String> inputFileIds) {
        this.inputFileIds = inputFileIds == null || inputFileIds.isEmpty() ? null : new ArrayList<String>(inputFileIds);
        return this;
    }

    public JobBuilder withInputFile(ConversionFile inputFile) {
        Objects.requireNonNull(inputFile);
        if (this.inputFileIds == null || this.inputFileIds.isEmpty()) {
            this.fromMediaType(inputFile.getMediaType());
        }
        return this.withInputFileId(inputFile.getFileId());
    }

    public JobBuilder withInputFileId(String inputFileId) {
        if (this.inputFileIds == null) {
            return this.inputFileIds(Collections.singletonList(inputFileId));
        }
        if (!this.inputFileIds.contains(inputFileId)) {
            this.inputFileIds.add(inputFileId);
        }
        return this;
    }

    public JobBuilder toMediaType(MediaType toMediaType) {
        this.toMediaType = toMediaType;
        return this;
    }

    public JobBuilder resultFiles(List<ConversionFile> resultFiles) {
        if (resultFiles == null || resultFiles.isEmpty()) {
            this.resultFileIds = null;
            return this;
        }
        return this.resultFileIds(resultFiles.stream().map(ConversionFile::getFileId).collect(Collectors.toList()));
    }

    public JobBuilder resultFileIds(List<String> resultFileIds) {
        this.resultFileIds = resultFileIds == null || resultFileIds.isEmpty() ? null : new ArrayList<String>(resultFileIds);
        return this;
    }

    public JobBuilder withResultFileId(String resultFileId) {
        if (this.resultFileIds == null) {
            this.resultFileIds = new ArrayList<String>();
            this.resultFileIds.add(resultFileId);
        } else if (!this.resultFileIds.contains(resultFileId)) {
            this.resultFileIds.add(resultFileId);
        }
        return this;
    }

    public JobBuilder state(JobState state) {
        this.state = state;
        return this;
    }

    public JobBuilder error(Error error) {
        if (error != null) {
            this.state(JobState.ERROR);
        }
        this.error = error;
        return this;
    }

    public JobBuilder properties(Map<String, String> properties) {
        this.properties = properties == null ? null : new HashMap<String, String>(properties);
        return this;
    }

    public JobBuilder withProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(name, value);
        return this;
    }

    public JobBuilder created(Instant created) {
        this.created = created;
        return this;
    }

    public JobBuilder updated(Instant updated) {
        this.updated = updated;
        return this;
    }

    public JobBuilder estimatedRunTime(Duration estimatedRunTime) {
        this.estimatedRunTime = estimatedRunTime;
        return this;
    }

    public JobBuilder referrer(String referrer) {
        this.referrer = referrer;
        return this;
    }

    public JobBuilder cancelTimeout(Duration cancelTimeout) {
        this.cancelTimeout = cancelTimeout;
        return this;
    }

    public JobBuilder deleteTimeout(Duration deleteTimeout) {
        this.deleteTimeout = deleteTimeout;
        return this;
    }

    public Job build() {
        return new JobImpl(this);
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getParentJobId() {
        return this.parentJobId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public String getConverterId() {
        return this.converterId;
    }

    public int getPriority() {
        return this.priority;
    }

    public MediaType getFromMediaType() {
        return this.fromMediaType;
    }

    public List<String> getInputFileIds() {
        return this.inputFileIds;
    }

    public MediaType getToMediaType() {
        return this.toMediaType;
    }

    public List<String> getResultFileIds() {
        return this.resultFileIds;
    }

    public JobState getState() {
        return this.state;
    }

    public Error getError() {
        return this.error;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public Instant getCreated() {
        return this.created;
    }

    public Instant getUpdated() {
        return this.updated;
    }

    public Duration getEstimatedRunTime() {
        return this.estimatedRunTime;
    }

    public String getReferrer() {
        return this.referrer;
    }

    public Duration getCancelTimeout() {
        return this.cancelTimeout;
    }

    public Duration getDeleteTimeout() {
        return this.deleteTimeout;
    }
}

