/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.model.v1.builder;

import de.mklinger.qetcher.client.mediatype.MediaType;
import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.impl.ConversionFileImpl;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class ConversionFileBuilder {
    private String fileId;
    private boolean serviceManaged;
    private String tenantId;
    private String name;
    private BigInteger size;
    private MediaType mediaType;
    private List<String> nodeIds;
    private Duration deleteTimeout;
    private Instant created;
    private Instant updated;

    public static ConversionFileBuilder of(ConversionFile conversionFile) {
        return new ConversionFileBuilder().fileId(conversionFile.getFileId()).serviceManaged(conversionFile.isServiceManaged()).tenantId(conversionFile.getTenantId()).name(conversionFile.getName()).size(conversionFile.getSize()).mediaType(conversionFile.getMediaType()).nodeIds(conversionFile.getNodeIds()).deleteTimeout(conversionFile.getDeleteTimeout()).created(conversionFile.getCreated()).updated(Instant.now());
    }

    public ConversionFileBuilder fileId(String fileId) {
        this.fileId = fileId;
        return this;
    }

    public ConversionFileBuilder serviceManaged(boolean serviceManaged) {
        this.serviceManaged = serviceManaged;
        return this;
    }

    public ConversionFileBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public ConversionFileBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ConversionFileBuilder size(BigInteger size) {
        this.size = size;
        return this;
    }

    public ConversionFileBuilder mediaType(MediaType mediaType) {
        this.mediaType = mediaType;
        return this;
    }

    public ConversionFileBuilder nodeIds(List<String> nodeIds) {
        this.nodeIds = nodeIds == null || nodeIds.isEmpty() ? null : new ArrayList<String>(nodeIds);
        return this;
    }

    public ConversionFileBuilder withNodeId(String nodeId) {
        if (this.nodeIds == null) {
            this.nodeIds = new ArrayList<String>();
        }
        if (!this.nodeIds.contains(nodeId)) {
            this.nodeIds.add(nodeId);
        }
        return this;
    }

    public ConversionFileBuilder withoutNodeId(String nodeId) {
        if (this.nodeIds == null) {
            return this;
        }
        this.nodeIds.remove(nodeId);
        return this;
    }

    public ConversionFileBuilder deleteTimeout(Duration deleteTimeout) {
        this.deleteTimeout = deleteTimeout;
        return this;
    }

    public ConversionFileBuilder created(Instant created) {
        this.created = created;
        return this;
    }

    public ConversionFileBuilder updated(Instant updated) {
        this.updated = updated;
        return this;
    }

    public ConversionFile build() {
        return new ConversionFileImpl(this);
    }

    public String getFileId() {
        return this.fileId;
    }

    public boolean isServiceManaged() {
        return this.serviceManaged;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getName() {
        return this.name;
    }

    public BigInteger getSize() {
        return this.size;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public List<String> getNodeIds() {
        return this.nodeIds;
    }

    public Duration getDeleteTimeout() {
        return this.deleteTimeout;
    }

    public Instant getCreated() {
        return this.created;
    }

    public Instant getUpdated() {
        return this.updated;
    }
}

