/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.jetty.http2;

import de.mklinger.qetcher.client.jetty.http2.ErrorCode;
import de.mklinger.qetcher.client.jetty.http2.ISession;
import de.mklinger.qetcher.client.jetty.http2.frames.DataFrame;
import de.mklinger.qetcher.client.jetty.http2.frames.GoAwayFrame;
import de.mklinger.qetcher.client.jetty.http2.frames.HeadersFrame;
import de.mklinger.qetcher.client.jetty.http2.frames.PingFrame;
import de.mklinger.qetcher.client.jetty.http2.frames.PriorityFrame;
import de.mklinger.qetcher.client.jetty.http2.frames.PushPromiseFrame;
import de.mklinger.qetcher.client.jetty.http2.frames.ResetFrame;
import de.mklinger.qetcher.client.jetty.http2.frames.SettingsFrame;
import de.mklinger.qetcher.client.jetty.http2.frames.WindowUpdateFrame;
import de.mklinger.qetcher.client.jetty.http2.parser.Parser;
import de.mklinger.qetcher.client.jetty.io.AbstractConnection;
import de.mklinger.qetcher.client.jetty.io.ByteBufferPool;
import de.mklinger.qetcher.client.jetty.io.EndPoint;
import de.mklinger.qetcher.client.jetty.io.WriteFlusher;
import de.mklinger.qetcher.client.jetty.util.BufferUtil;
import de.mklinger.qetcher.client.jetty.util.Callback;
import de.mklinger.qetcher.client.jetty.util.Retainable;
import de.mklinger.qetcher.client.jetty.util.component.LifeCycle;
import de.mklinger.qetcher.client.jetty.util.log.Log;
import de.mklinger.qetcher.client.jetty.util.log.Logger;
import de.mklinger.qetcher.client.jetty.util.thread.ExecutionStrategy;
import de.mklinger.qetcher.client.jetty.util.thread.Invocable;
import de.mklinger.qetcher.client.jetty.util.thread.TryExecutor;
import de.mklinger.qetcher.client.jetty.util.thread.strategy.EatWhatYouKill;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class HTTP2Connection
extends AbstractConnection
implements WriteFlusher.Listener {
    protected static final Logger LOG = Log.getLogger(HTTP2Connection.class);
    private static final boolean PEC_MODE = Boolean.getBoolean("de.mklinger.qetcher.client.jetty.http2.PEC_MODE");
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>();
    private final HTTP2Producer producer = new HTTP2Producer();
    private final AtomicLong bytesIn = new AtomicLong();
    private final ByteBufferPool byteBufferPool;
    private final Parser parser;
    private final ISession session;
    private final int bufferSize;
    private final ExecutionStrategy strategy;

    public HTTP2Connection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, Parser parser, ISession session, int bufferSize) {
        super(endPoint, executor);
        this.byteBufferPool = byteBufferPool;
        this.parser = parser;
        this.session = session;
        this.bufferSize = bufferSize;
        if (PEC_MODE) {
            executor = new TryExecutor.NoTryExecutor(executor);
        }
        this.strategy = new EatWhatYouKill(this.producer, executor);
        LifeCycle.start(this.strategy);
        parser.init(x$0 -> new ParserListener((Parser.Listener)x$0));
    }

    @Override
    public long getBytesIn() {
        return this.bytesIn.get();
    }

    @Override
    public long getBytesOut() {
        return this.session.getBytesWritten();
    }

    public ISession getSession() {
        return this.session;
    }

    protected Parser getParser() {
        return this.parser;
    }

    protected void setInputBuffer(ByteBuffer buffer) {
        if (buffer != null) {
            this.producer.setInputBuffer(buffer);
        }
    }

    @Override
    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Open {} ", this);
        }
        super.onOpen();
    }

    @Override
    public void onClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Close {} ", this);
        }
        super.onClose();
        LifeCycle.stop(this.strategy);
    }

    @Override
    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 onFillable {} ", this);
        }
        this.produce();
    }

    private int fill(EndPoint endPoint, ByteBuffer buffer) {
        try {
            if (endPoint.isInputShutdown()) {
                return -1;
            }
            return endPoint.fill(buffer);
        }
        catch (IOException x) {
            LOG.debug("Could not read from " + endPoint, x);
            return -1;
        }
    }

    @Override
    public boolean onIdleExpired() {
        boolean close;
        boolean idle = this.isFillInterested();
        if (idle && (close = this.session.onIdleTimeout())) {
            this.session.close(ErrorCode.NO_ERROR.code, "idle_timeout", Callback.NOOP);
        }
        return false;
    }

    protected void offerTask(Runnable task, boolean dispatch) {
        this.offerTask(task);
        if (dispatch) {
            this.dispatch();
        } else {
            this.produce();
        }
    }

    protected void produce() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 produce {} ", this);
        }
        this.strategy.produce();
    }

    protected void dispatch() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 dispatch {} ", this);
        }
        this.strategy.dispatch();
    }

    @Override
    public void close() {
        this.session.close(ErrorCode.NO_ERROR.code, "close", Callback.NOOP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerTask(Runnable task) {
        HTTP2Connection hTTP2Connection = this;
        synchronized (hTTP2Connection) {
            this.tasks.offer(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runnable pollTask() {
        HTTP2Connection hTTP2Connection = this;
        synchronized (hTTP2Connection) {
            return this.tasks.poll();
        }
    }

    @Override
    public void onFlushed(long bytes) throws IOException {
        this.session.onFlushed(bytes);
    }

    private class NetworkBuffer
    implements Callback,
    Retainable {
        private final AtomicInteger refCount = new AtomicInteger();
        private final ByteBuffer buffer;

        private NetworkBuffer() {
            this.buffer = HTTP2Connection.this.byteBufferPool.acquire(HTTP2Connection.this.bufferSize, false);
        }

        private void put(ByteBuffer source) {
            BufferUtil.append(this.buffer, source);
        }

        private boolean hasRemaining() {
            return this.buffer.hasRemaining();
        }

        @Override
        public void retain() {
            this.refCount.incrementAndGet();
        }

        @Override
        public void succeeded() {
            this.release();
        }

        @Override
        public void failed(Throwable x) {
            this.release();
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }

        private void release() {
            if (this.tryRelease()) {
                HTTP2Connection.this.byteBufferPool.release(this.buffer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Released retained {}", this);
                }
            }
        }

        private boolean tryRelease() {
            return this.refCount.decrementAndGet() == 0;
        }

        public String toString() {
            return String.format("%s@%x[%s]", this.getClass().getSimpleName(), this.hashCode(), this.buffer);
        }
    }

    private class ParserListener
    implements Parser.Listener {
        private final Parser.Listener listener;

        private ParserListener(Parser.Listener listener) {
            this.listener = listener;
        }

        @Override
        public void onData(DataFrame frame) {
            NetworkBuffer buffer = HTTP2Connection.this.producer.buffer;
            buffer.retain();
            NetworkBuffer callback = buffer;
            HTTP2Connection.this.session.onData(frame, callback);
        }

        @Override
        public void onHeaders(HeadersFrame frame) {
            this.listener.onHeaders(frame);
        }

        @Override
        public void onPriority(PriorityFrame frame) {
            this.listener.onPriority(frame);
        }

        @Override
        public void onReset(ResetFrame frame) {
            this.listener.onReset(frame);
        }

        @Override
        public void onSettings(SettingsFrame frame) {
            this.listener.onSettings(frame);
        }

        @Override
        public void onPushPromise(PushPromiseFrame frame) {
            this.listener.onPushPromise(frame);
        }

        @Override
        public void onPing(PingFrame frame) {
            this.listener.onPing(frame);
        }

        @Override
        public void onGoAway(GoAwayFrame frame) {
            this.listener.onGoAway(frame);
        }

        @Override
        public void onWindowUpdate(WindowUpdateFrame frame) {
            this.listener.onWindowUpdate(frame);
        }

        @Override
        public void onConnectionFailure(int error, String reason) {
            this.listener.onConnectionFailure(error, reason);
        }
    }

    private class FillableCallback
    implements Callback {
        private FillableCallback() {
        }

        @Override
        public void succeeded() {
            HTTP2Connection.this.onFillable();
        }

        @Override
        public void failed(Throwable x) {
            HTTP2Connection.this.onFillInterestedFailed(x);
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.EITHER;
        }
    }

    protected class HTTP2Producer
    implements ExecutionStrategy.Producer {
        private final Callback fillableCallback;
        private NetworkBuffer buffer;
        private boolean shutdown;

        protected HTTP2Producer() {
            this.fillableCallback = new FillableCallback();
        }

        private void setInputBuffer(ByteBuffer byteBuffer) {
            if (this.buffer == null) {
                this.buffer = this.acquireNetworkBuffer();
            }
            this.buffer.put(byteBuffer);
        }

        @Override
        public Runnable produce() {
            Runnable task = HTTP2Connection.this.pollTask();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dequeued task {}", task);
            }
            if (task != null) {
                return task;
            }
            if (HTTP2Connection.this.isFillInterested() || this.shutdown) {
                return null;
            }
            if (this.buffer == null) {
                this.buffer = this.acquireNetworkBuffer();
            }
            boolean parse = this.buffer.hasRemaining();
            while (true) {
                if (parse) {
                    this.buffer.retain();
                    while (this.buffer.hasRemaining()) {
                        HTTP2Connection.this.parser.parse(this.buffer.buffer);
                    }
                    boolean released = this.buffer.tryRelease();
                    task = HTTP2Connection.this.pollTask();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Dequeued new task {}", task);
                    }
                    if (task != null) {
                        if (released) {
                            this.releaseNetworkBuffer();
                        } else {
                            this.buffer = null;
                        }
                        return task;
                    }
                    if (!released) {
                        this.buffer = this.acquireNetworkBuffer();
                    }
                }
                int filled = HTTP2Connection.this.fill(HTTP2Connection.this.getEndPoint(), this.buffer.buffer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Filled {} bytes in {}", filled, this.buffer);
                }
                if (filled == 0) {
                    this.releaseNetworkBuffer();
                    HTTP2Connection.this.getEndPoint().fillInterested(this.fillableCallback);
                    return null;
                }
                if (filled < 0) {
                    this.releaseNetworkBuffer();
                    this.shutdown = true;
                    HTTP2Connection.this.session.onShutdown();
                    return null;
                }
                HTTP2Connection.this.bytesIn.addAndGet(filled);
                parse = true;
            }
        }

        private NetworkBuffer acquireNetworkBuffer() {
            NetworkBuffer networkBuffer = new NetworkBuffer();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Acquired {}", networkBuffer);
            }
            return networkBuffer;
        }

        private void releaseNetworkBuffer() {
            if (!this.buffer.hasRemaining()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Released {}", this.buffer);
                }
                this.buffer.release();
                HTTP2Connection.this.byteBufferPool.release(this.buffer.buffer);
                this.buffer = null;
            }
        }

        public String toString() {
            return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
        }
    }
}

