/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.jackson.databind.ser.std;

import de.mklinger.qetcher.client.jackson.core.JsonGenerator;
import de.mklinger.qetcher.client.jackson.databind.JavaType;
import de.mklinger.qetcher.client.jackson.databind.JsonMappingException;
import de.mklinger.qetcher.client.jackson.databind.SerializerProvider;
import de.mklinger.qetcher.client.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import de.mklinger.qetcher.client.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import de.mklinger.qetcher.client.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import de.mklinger.qetcher.client.jackson.databind.ser.std.StdScalarSerializer;
import de.mklinger.qetcher.client.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class ByteBufferSerializer
extends StdScalarSerializer<ByteBuffer> {
    public ByteBufferSerializer() {
        super(ByteBuffer.class);
    }

    @Override
    public void serialize(ByteBuffer bbuf, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (bbuf.hasArray()) {
            gen.writeBinary(bbuf.array(), 0, bbuf.limit());
            return;
        }
        ByteBuffer copy = bbuf.asReadOnlyBuffer();
        if (copy.position() > 0) {
            copy.rewind();
        }
        ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(copy);
        gen.writeBinary(in, copy.remaining());
        in.close();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

