/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.impl;

import de.mklinger.qetcher.client.InputConversionFile;
import de.mklinger.qetcher.client.InputJob;
import de.mklinger.qetcher.client.QetcherClientVersion;
import de.mklinger.qetcher.client.httpclient.BodyHandlers;
import de.mklinger.qetcher.client.httpclient.BodyProviders;
import de.mklinger.qetcher.client.httpclient.HttpClient;
import de.mklinger.qetcher.client.httpclient.HttpRequest;
import de.mklinger.qetcher.client.httpclient.HttpResponse;
import de.mklinger.qetcher.client.impl.AbstractQetcherClient;
import de.mklinger.qetcher.client.impl.QetcherClientBuilderImpl;
import de.mklinger.qetcher.client.impl.lookup.ServiceUriSupplier;
import de.mklinger.qetcher.client.model.v1.AvailableConversion;
import de.mklinger.qetcher.client.model.v1.AvailableConversions;
import de.mklinger.qetcher.client.model.v1.AvailableNode;
import de.mklinger.qetcher.client.model.v1.AvailableNodes;
import de.mklinger.qetcher.client.model.v1.ConversionFile;
import de.mklinger.qetcher.client.model.v1.ConversionFiles;
import de.mklinger.qetcher.client.model.v1.Job;
import de.mklinger.qetcher.client.model.v1.Jobs;
import java.net.URI;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QetcherClientImpl
extends AbstractQetcherClient {
    private static final String USER_AGENT = "User-Agent";
    private static final String USER_AGENT_VALUE = "qetcher-client/" + QetcherClientVersion.getVersion();
    private static final Logger LOG = LoggerFactory.getLogger(QetcherClientImpl.class);
    private final HttpClient httpClient;

    public QetcherClientImpl(QetcherClientBuilderImpl builder, ServiceUriSupplier serviceUriSupplier) {
        super(serviceUriSupplier);
        this.httpClient = this.newHttpClient(builder);
    }

    private HttpClient newHttpClient(QetcherClientBuilderImpl builder) {
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
        if (builder.getTrustStore() != null) {
            httpClientBuilder.trustStore(builder.getTrustStore());
        }
        if (builder.getKeyStore() != null) {
            httpClientBuilder.keyStore(builder.getKeyStore(), builder.getKeyPassword());
        }
        return httpClientBuilder.followRedirects(true).build();
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    @Override
    public CompletableFuture<ConversionFile> uploadFile(InputConversionFile inputFile) {
        HttpRequest.Builder rb = this.newRequestBuilder(this.getFileUploadUri()).method(this.getFileUploadMethod(), inputFile.getBodyProvider());
        rb.header("Content-Type", inputFile.getMediaType().toString());
        if (inputFile.getDeleteTimeout() != null) {
            rb.header("X-Qetcher-Delete-Timeout", inputFile.getDeleteTimeout().toString());
        }
        if (inputFile.getFilename() != null && !inputFile.getFilename().isEmpty()) {
            rb.header("X-Qetcher-Filename", inputFile.getFilename());
        }
        return this.sendForBytes(rb.build()).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)ConversionFile.class));
    }

    @Override
    public CompletableFuture<ConversionFile> getFile(String fileId) {
        HttpRequest request = this.newRequestBuilder(this.getFileUri(fileId)).GET().build();
        return this.sendForBytes(request).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)ConversionFile.class));
    }

    @Override
    public CompletableFuture<List<ConversionFile>> getFiles() {
        HttpRequest request = this.newRequestBuilder(this.getFilesUri()).GET().build();
        return ((CompletableFuture)this.sendForBytes(request).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)ConversionFiles.class))).thenApply(ConversionFiles::getConversionFiles);
    }

    @Override
    public CompletableFuture<Void> deleteFile(String fileId) {
        HttpRequest request = this.newRequestBuilder(this.getFileUri(fileId)).DELETE(BodyProviders.noBody()).build();
        return this.sendForBytes(request).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)Void.class));
    }

    @Override
    public CompletableFuture<Path> downloadAsFile(String fileId, Path file, OpenOption ... openOptions) {
        HttpRequest request = this.newRequestBuilder(this.getFileContentsUri(fileId)).GET().build();
        LOG.debug("{} {}", (Object)request.method(), (Object)request.uri());
        return this.httpClient.sendAsync(request, this.asSuccessStatusFile(file, openOptions)).thenApply(HttpResponse::body);
    }

    private HttpResponse.BodyHandler<Path> asSuccessStatusFile(Path file, OpenOption ... openOptions) {
        return (status, headers) -> {
            this.requireSuccessStatusCode(status, Optional.empty(), Optional.empty());
            return BodyHandlers.asFile(file, openOptions).apply(status, headers);
        };
    }

    @Override
    public CompletableFuture<Job> createJob(InputJob inputJob) {
        if (inputJob.getInputConversionFile() != null) {
            return this.createJobWithUpload(inputJob);
        }
        return this.createJobForExistingFile(inputJob);
    }

    private CompletableFuture<Job> createJobWithUpload(InputJob inputJob) {
        HttpRequest.Builder rb = this.newRequestBuilder(this.getCreateJobForNewFileUri()).method(this.getFileUploadMethod(), inputJob.getInputConversionFile().getBodyProvider());
        rb.header("Content-Type", inputJob.getFromMediaType().toString());
        rb.header("X-Qetcher-Target-Content-Type", inputJob.getToMediaType().toString());
        if (inputJob.getInputConversionFile().getFilename() != null && !inputJob.getInputConversionFile().getFilename().isEmpty()) {
            rb.header("X-Qetcher-Filename", inputJob.getInputConversionFile().getFilename());
        }
        if (inputJob.getDeleteTimeout() != null) {
            rb.header("X-Qetcher-Delete-Timeout", inputJob.getDeleteTimeout().toString());
        }
        if (inputJob.getCancelTimeout() != null) {
            rb.header("X-Qetcher-Cancel-Timeout", inputJob.getCancelTimeout().toString());
        }
        if (inputJob.getReferrer() != null) {
            rb.header("Referer", inputJob.getReferrer());
        }
        return this.sendForBytes(rb.build()).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)Job.class));
    }

    private CompletableFuture<Job> createJobForExistingFile(InputJob inputJob) {
        HttpRequest.Builder rb = this.newRequestBuilder(this.getCreateJobForExistingFileUri()).method(this.getCreateJobForExistingFileMethod(), BodyProviders.noBody());
        rb.header("X-Qetcher-FileId", inputJob.getConversionFileId());
        rb.header("X-Qetcher-Target-Content-Type", inputJob.getToMediaType().toString());
        if (inputJob.getDeleteTimeout() != null) {
            rb.header("X-Qetcher-Delete-Timeout", inputJob.getDeleteTimeout().toString());
        }
        if (inputJob.getCancelTimeout() != null) {
            rb.header("X-Qetcher-Cancel-Timeout", inputJob.getCancelTimeout().toString());
        }
        if (inputJob.getReferrer() != null) {
            rb.header("Referer", inputJob.getReferrer());
        }
        return this.sendForBytes(rb.build()).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)Job.class));
    }

    @Override
    public CompletableFuture<Job> getJob(String jobId) {
        HttpRequest request = this.newRequestBuilder(this.getJobUri(jobId)).GET().build();
        return this.sendForBytes(request).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)Job.class));
    }

    @Override
    public CompletableFuture<List<Job>> getJobs() {
        HttpRequest request = this.newRequestBuilder(this.getJobsUri()).GET().build();
        return ((CompletableFuture)this.sendForBytes(request).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)Jobs.class))).thenApply(Jobs::getJobs);
    }

    @Override
    public CompletableFuture<Void> deleteJob(String jobId) {
        HttpRequest request = this.newRequestBuilder(this.getJobUri(jobId)).DELETE(BodyProviders.noBody()).build();
        return this.sendForBytes(request).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)Void.class));
    }

    @Override
    public CompletableFuture<List<AvailableConversion>> getAvailableConversions() {
        HttpRequest request = this.newRequestBuilder(this.getConversionsUri()).GET().build();
        return ((CompletableFuture)this.sendForBytes(request).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)AvailableConversions.class))).thenApply(AvailableConversions::getAvailableConversions);
    }

    @Override
    public CompletableFuture<List<AvailableNode>> getAvailableNodes() {
        URI uri = this.getAvailableNodesUri();
        HttpRequest request = this.newRequestBuilder(uri).GET().build();
        return ((CompletableFuture)this.sendForBytes(request).thenApply(response -> this.transformResponse((HttpResponse<byte[]>)response, (Class)AvailableNodes.class))).thenApply(AvailableNodes::getAvailableNodes);
    }

    private HttpRequest.Builder newRequestBuilder(URI uri) {
        return HttpRequest.newBuilder().uri(uri).header(USER_AGENT, USER_AGENT_VALUE);
    }

    private CompletableFuture<HttpResponse<byte[]>> sendForBytes(HttpRequest request) {
        LOG.debug("{} {}", (Object)request.method(), (Object)request.uri());
        return this.httpClient.sendAsync(request, BodyHandlers.asByteArray());
    }

    private <T> T transformResponse(HttpResponse<byte[]> response, Class<T> type) {
        return this.transformResponse(response.statusCode(), response.headers().firstValue("Content-Type"), response.body(), type);
    }
}

