/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.httpclient.internal;

import de.mklinger.qetcher.client.httpclient.HttpHeaders;
import de.mklinger.qetcher.client.httpclient.HttpResponse;
import de.mklinger.qetcher.client.httpclient.internal.StringCompleteListener;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringBodyHandler
implements HttpResponse.BodyHandler<String> {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Pattern CHARSET_PATTERN = Pattern.compile(".*;\\s*charset\\s*=([^;]+)", 2);
    private static final Logger LOG = LoggerFactory.getLogger(StringBodyHandler.class);

    @Override
    public HttpResponse.BodyCompleteListener<String> apply(int statusCode, HttpHeaders responseHeaders) {
        Charset charset = this.findCharset(responseHeaders);
        return new StringCompleteListener(charset);
    }

    private Charset findCharset(HttpHeaders responseHeaders) {
        Optional<String> contentType = responseHeaders.firstValue("content-type");
        return this.findCharset(contentType);
    }

    private Charset findCharset(Optional<String> contentType) {
        if (contentType.isPresent()) {
            return this.findCharset(contentType.get());
        }
        LOG.warn("No Content-Type header present in response. Assuming charset {}", (Object)DEFAULT_CHARSET);
        return DEFAULT_CHARSET;
    }

    private Charset findCharset(String contentType) {
        Matcher matcher = CHARSET_PATTERN.matcher(contentType);
        if (!matcher.matches()) {
            LOG.warn("No charset parameter present in Content-Type header. Assuming charset {}", (Object)DEFAULT_CHARSET);
            return DEFAULT_CHARSET;
        }
        String charset = matcher.group(1).trim();
        return this.charsetForName(charset);
    }

    private Charset charsetForName(String cs) {
        try {
            return Charset.forName(cs);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            LOG.warn("Unable to use charset parameter present in Content-Type header. Assuming charset {}", (Object)DEFAULT_CHARSET);
            return DEFAULT_CHARSET;
        }
    }
}

