package de.mklinger.qetcher.client.model.v1.builder;

import java.util.HashSet;
import java.util.Set;

import de.mklinger.micro.mediatype.MediaType;
import de.mklinger.qetcher.client.model.v1.Conversion;
import de.mklinger.qetcher.client.model.v1.impl.ConversionImpl;

/**
 * Created by Marius Heinzmann on 3/26/18.
 *
 * @author Marius Heinzmann - mheinzmann[at]mklinger[dot]de
 */
public class ConversionBuilder {
	private MediaType from;
	private MediaType to;
	private int priority;
	private Set<String> supportedParameters;

	public static ConversionBuilder of(final Conversion conversion) {
		return new ConversionBuilder()
				.from(conversion.getFrom())
				.to(conversion.getTo())
				.priority(conversion.getPriority())
				.supportedParameters(conversion.getSupportedParameters());
	}

	public ConversionBuilder from(final MediaType from) {
		this.from = from;
		return this;
	}

	public ConversionBuilder to(final MediaType to) {
		this.to = to;
		return this;
	}

	public ConversionBuilder priority(final int priority) {
		this.priority = priority;
		return this;
	}

	public ConversionBuilder supportedParameters(final Set<String> supportedParameters) {
		if (supportedParameters == null || supportedParameters.isEmpty()) {
			this.supportedParameters = null;
		} else {
			this.supportedParameters = new HashSet<>(supportedParameters);
		}
		return this;
	}

	public ConversionBuilder withSupportedParameter(final String supportedParameter) {
		if (supportedParameters == null) {
			this.supportedParameters = new HashSet<>();
		}
		this.supportedParameters.add(supportedParameter);
		return this;
	}

	public MediaType getFrom() {
		return from;
	}

	public MediaType getTo() {
		return to;
	}

	public int getPriority() {
		return priority;
	}

	public Set<String> getSupportedParameters() {
		return supportedParameters;
	}

	public Conversion build() {
		return new ConversionImpl(this);
	}
}
