/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.httpclient.internal.jetty;

import de.mklinger.qetcher.client.deps.jetty.client.api.Request;
import de.mklinger.qetcher.client.deps.jetty.client.api.Response;
import de.mklinger.qetcher.client.deps.jetty.client.util.DeferredContentProvider;
import de.mklinger.qetcher.client.deps.jetty.http2.HTTP2Session;
import de.mklinger.qetcher.client.deps.jetty.util.Callback;
import de.mklinger.qetcher.client.deps.jetty.util.component.Container;
import de.mklinger.qetcher.client.httpclient.HttpClient;
import de.mklinger.qetcher.client.httpclient.HttpRequest;
import de.mklinger.qetcher.client.httpclient.HttpResponse;
import de.mklinger.qetcher.client.httpclient.internal.jetty.BodyResult;
import de.mklinger.qetcher.client.httpclient.internal.jetty.FullCompleteListener;
import de.mklinger.qetcher.client.httpclient.internal.jetty.HeadersTransformation;
import de.mklinger.qetcher.client.httpclient.internal.jetty.JettyHttpRequest;
import de.mklinger.qetcher.client.httpclient.internal.jetty.JettyHttpResponse;
import de.mklinger.qetcher.client.httpclient.internal.jetty.TimeoutResponseListener;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyHttpClient
implements HttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(JettyHttpClient.class);
    private final de.mklinger.qetcher.client.deps.jetty.client.HttpClient jettyClient;
    private volatile boolean closed = false;
    private static final AtomicLong openSessions = new AtomicLong();

    public JettyHttpClient(de.mklinger.qetcher.client.deps.jetty.client.HttpClient jettyClient) {
        this.jettyClient = jettyClient;
        this.jettyClient.addEventListener(new SessionCountListener());
    }

    private de.mklinger.qetcher.client.deps.jetty.client.HttpClient getJettyClient() {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        return this.jettyClient;
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) {
        try {
            Request jettyRequest = this.getJettyClient().newRequest(request.uri()).method(request.method());
            this.applyTimeout(request, jettyRequest);
            this.applyHeaders(request, jettyRequest);
            this.applyBody(request, jettyRequest);
            ForkJoinPool completionExecutor = ForkJoinPool.commonPool();
            FullCompleteListener<T> fullCompleteListener = new FullCompleteListener<T>(completionExecutor, responseBodyHandler);
            Response.CompleteListener possibleTimeoutCompleteListener = this.applyTimeout(request, jettyRequest, fullCompleteListener);
            LOG.debug("Sending jetty request");
            jettyRequest.send(possibleTimeoutCompleteListener);
            return fullCompleteListener.getResult().thenApply(this::toHttpResponse);
        }
        catch (Throwable e) {
            CompletableFuture<HttpResponse<T>> errorResult = new CompletableFuture<HttpResponse<T>>();
            errorResult.completeExceptionally(e);
            return errorResult;
        }
    }

    private void applyTimeout(HttpRequest request, Request jettyRequest) {
        Optional<Duration> timeout = request.timeout();
        if (!timeout.isPresent()) {
            return;
        }
        try {
            jettyRequest.timeout(timeout.get().toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (ArithmeticException ex) {
            jettyRequest.timeout(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
    }

    private <T> Response.CompleteListener applyTimeout(HttpRequest request, Request jettyRequest, FullCompleteListener<T> fullCompleteListener) {
        if (request.timeout().isPresent()) {
            return new TimeoutResponseListener(fullCompleteListener, jettyRequest, request.timeout().get().toMillis(), TimeUnit.MILLISECONDS, this.getJettyClient().getScheduler());
        }
        return fullCompleteListener;
    }

    private void applyHeaders(HttpRequest request, Request jettyRequest) {
        request.headers().map().forEach((name, values) -> values.forEach(value -> jettyRequest.header((String)name, (String)value)));
    }

    private void applyBody(HttpRequest request, Request jettyRequest) {
        Optional<HttpRequest.BodyProvider> optionalBodyProvider = request.bodyProvider();
        if (!optionalBodyProvider.isPresent()) {
            return;
        }
        HttpRequest.BodyProvider bodyProvider = optionalBodyProvider.get();
        final long contentLength = this.getContentLength(bodyProvider);
        if (contentLength == 0L) {
            return;
        }
        Optional<String> bodyProviderContentType = bodyProvider.contentType();
        if (bodyProviderContentType.isPresent() && jettyRequest.getHeaders().get("Content-Type") == null) {
            jettyRequest.header("Content-Type", bodyProviderContentType.get());
        }
        DeferredContentProvider deferredContentProvider = new DeferredContentProvider(new ByteBuffer[0]){

            @Override
            public long getLength() {
                return contentLength;
            }
        };
        RequestBodyFiller requestBodyFiller = new RequestBodyFiller(bodyProvider.iterator(), deferredContentProvider, jettyRequest);
        requestBodyFiller.start();
        jettyRequest.content(deferredContentProvider);
    }

    private long getContentLength(HttpRequest.BodyProvider bodyProvider) {
        long contentLength = bodyProvider.contentLength();
        if (contentLength >= 0L) {
            return contentLength;
        }
        return -1L;
    }

    private <T> HttpResponse<T> toHttpResponse(BodyResult<T> result) {
        LOG.debug("Building final HttpResponse");
        return new JettyHttpResponse<T>(result.getResult().getResponse().getStatus(), new JettyHttpRequest(result.getResult().getRequest()), HeadersTransformation.toHttpHeaders(result.getResult().getResponse().getHeaders()), result.getBody());
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            this.jettyClient.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static class RequestBodyFiller {
        private final Iterator<CompletableFuture<ByteBuffer>> chunkFutureIterator;
        private final DeferredContentProvider deferredContentProvider;
        private final Request jettyRequest;
        private final AtomicReference<Throwable> error = new AtomicReference();
        private final Object pendingLock = new Object();
        private long pendingOffers = 0L;
        private boolean pendingRead = false;
        private static final long MAX_PENDING_OFFERS = 5L;
        private final Callback offerCallback = new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void succeeded() {
                Object object = pendingLock;
                synchronized (object) {
                    pendingOffers--;
                    this.fillIfPossible();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(Throwable e) {
                Object object = pendingLock;
                synchronized (object) {
                    pendingOffers--;
                }
                this.error(e);
            }
        };

        public RequestBodyFiller(Iterator<CompletableFuture<ByteBuffer>> chunkFutureIterator, DeferredContentProvider deferredContentProvider, Request jettyRequest) {
            this.chunkFutureIterator = chunkFutureIterator;
            this.deferredContentProvider = deferredContentProvider;
            this.jettyRequest = jettyRequest;
        }

        private void fillIfPossible() {
            if (!Thread.holdsLock(this.pendingLock)) {
                throw new IllegalStateException();
            }
            if (this.pendingOffers < 5L && !this.pendingRead) {
                LOG.debug("Filling with {} pending offers", (Object)this.pendingOffers);
                this.fill();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            Object object = this.pendingLock;
            synchronized (object) {
                this.fill();
            }
        }

        private void fill() {
            if (this.isError()) {
                return;
            }
            try {
                if (!Thread.holdsLock(this.pendingLock)) {
                    throw new IllegalStateException();
                }
                if (this.pendingRead) {
                    throw new IllegalStateException();
                }
                this.pendingRead = true;
                if (this.chunkFutureIterator.hasNext()) {
                    this.chunkFutureIterator.next().whenComplete(this::chunkFutureComplete);
                } else {
                    this.done();
                }
            }
            catch (Throwable e) {
                this.error(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void chunkFutureComplete(ByteBuffer byteBuffer, Throwable error) {
            if (error != null) {
                this.error(error);
                return;
            }
            boolean success = this.deferredContentProvider.offer(byteBuffer, this.offerCallback);
            if (!success) {
                this.error(new RuntimeException("Failed to offer content to deferred content provider"));
            }
            Object object = this.pendingLock;
            synchronized (object) {
                ++this.pendingOffers;
                this.pendingRead = false;
                this.fillIfPossible();
            }
        }

        private void done() {
            this.deferredContentProvider.close();
        }

        public void error(Throwable error) {
            boolean set = this.error.compareAndSet(null, error);
            if (!set && this.error.get() != error) {
                this.error.get().addSuppressed(error);
            }
            this.jettyRequest.abort(this.error.get());
            this.deferredContentProvider.close();
        }

        public boolean isError() {
            return this.error.get() != null;
        }
    }

    private final class SessionCountListener
    implements Container.InheritedListener {
        private SessionCountListener() {
        }

        @Override
        public void beanAdded(Container parent, Object child) {
            if (child instanceof HTTP2Session) {
                HTTP2Session session = (HTTP2Session)child;
                LOG.debug("Opened HTTP/2 session: {}", (Object)session.getEndPoint().getRemoteAddress());
                openSessions.incrementAndGet();
            }
        }

        @Override
        public void beanRemoved(Container parent, Object child) {
            if (child instanceof HTTP2Session) {
                HTTP2Session session = (HTTP2Session)child;
                LOG.debug("Closed HTTP/2 session: {}", (Object)session.getEndPoint().getRemoteAddress());
                openSessions.decrementAndGet();
            }
        }
    }
}

