/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.deps.jetty.http2.hpack;

import de.mklinger.qetcher.client.deps.jetty.http.HttpFieldPreEncoder;
import de.mklinger.qetcher.client.deps.jetty.http.HttpHeader;
import de.mklinger.qetcher.client.deps.jetty.http.HttpVersion;
import de.mklinger.qetcher.client.deps.jetty.http2.hpack.HpackContext;
import de.mklinger.qetcher.client.deps.jetty.http2.hpack.HpackEncoder;
import de.mklinger.qetcher.client.deps.jetty.http2.hpack.Huffman;
import de.mklinger.qetcher.client.deps.jetty.http2.hpack.NBitInteger;
import de.mklinger.qetcher.client.deps.jetty.util.BufferUtil;
import java.nio.ByteBuffer;

public class HpackFieldPreEncoder
implements HttpFieldPreEncoder {
    @Override
    public HttpVersion getHttpVersion() {
        return HttpVersion.HTTP_2;
    }

    @Override
    public byte[] getEncodedField(HttpHeader header, String name, String value) {
        int bits;
        boolean huffman;
        boolean not_indexed = HpackEncoder.__DO_NOT_INDEX.contains((Object)header);
        ByteBuffer buffer = BufferUtil.allocate(name.length() + value.length() + 10);
        BufferUtil.clearToFill(buffer);
        if (not_indexed) {
            boolean never_index = HpackEncoder.__NEVER_INDEX.contains((Object)header);
            huffman = !HpackEncoder.__DO_NOT_HUFFMAN.contains((Object)header);
            buffer.put(never_index ? (byte)16 : 0);
            bits = 4;
        } else if (header == HttpHeader.CONTENT_LENGTH && value.length() > 1) {
            buffer.put((byte)0);
            huffman = true;
            bits = 4;
        } else {
            buffer.put((byte)64);
            huffman = !HpackEncoder.__DO_NOT_HUFFMAN.contains((Object)header);
            bits = 6;
        }
        int name_idx = HpackContext.staticIndex(header);
        if (name_idx > 0) {
            NBitInteger.encode(buffer, bits, name_idx);
        } else {
            buffer.put((byte)-128);
            NBitInteger.encode(buffer, 7, Huffman.octetsNeededLC(name));
            Huffman.encodeLC(buffer, name);
        }
        HpackEncoder.encodeValue(buffer, huffman, value);
        BufferUtil.flipToFlush(buffer, 0);
        return BufferUtil.toArray(buffer);
    }
}

