/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.deps.jetty.client;

import de.mklinger.qetcher.client.deps.jetty.client.ContentDecoder;
import de.mklinger.qetcher.client.deps.jetty.client.ContinueProtocolHandler;
import de.mklinger.qetcher.client.deps.jetty.client.GZIPContentDecoder;
import de.mklinger.qetcher.client.deps.jetty.client.HttpAuthenticationStore;
import de.mklinger.qetcher.client.deps.jetty.client.HttpClientTransport;
import de.mklinger.qetcher.client.deps.jetty.client.HttpConversation;
import de.mklinger.qetcher.client.deps.jetty.client.HttpDestination;
import de.mklinger.qetcher.client.deps.jetty.client.HttpRequest;
import de.mklinger.qetcher.client.deps.jetty.client.Origin;
import de.mklinger.qetcher.client.deps.jetty.client.ProtocolHandler;
import de.mklinger.qetcher.client.deps.jetty.client.ProtocolHandlers;
import de.mklinger.qetcher.client.deps.jetty.client.ProxyAuthenticationProtocolHandler;
import de.mklinger.qetcher.client.deps.jetty.client.ProxyConfiguration;
import de.mklinger.qetcher.client.deps.jetty.client.RedirectProtocolHandler;
import de.mklinger.qetcher.client.deps.jetty.client.WWWAuthenticationProtocolHandler;
import de.mklinger.qetcher.client.deps.jetty.client.api.AuthenticationStore;
import de.mklinger.qetcher.client.deps.jetty.client.api.Connection;
import de.mklinger.qetcher.client.deps.jetty.client.api.ContentResponse;
import de.mklinger.qetcher.client.deps.jetty.client.api.Destination;
import de.mklinger.qetcher.client.deps.jetty.client.api.Request;
import de.mklinger.qetcher.client.deps.jetty.client.api.Response;
import de.mklinger.qetcher.client.deps.jetty.client.http.HttpClientTransportOverHTTP;
import de.mklinger.qetcher.client.deps.jetty.client.util.FormContentProvider;
import de.mklinger.qetcher.client.deps.jetty.http.HttpCompliance;
import de.mklinger.qetcher.client.deps.jetty.http.HttpField;
import de.mklinger.qetcher.client.deps.jetty.http.HttpHeader;
import de.mklinger.qetcher.client.deps.jetty.http.HttpMethod;
import de.mklinger.qetcher.client.deps.jetty.http.HttpScheme;
import de.mklinger.qetcher.client.deps.jetty.io.ByteBufferPool;
import de.mklinger.qetcher.client.deps.jetty.io.ClientConnectionFactory;
import de.mklinger.qetcher.client.deps.jetty.io.MappedByteBufferPool;
import de.mklinger.qetcher.client.deps.jetty.io.ssl.SslClientConnectionFactory;
import de.mklinger.qetcher.client.deps.jetty.util.Fields;
import de.mklinger.qetcher.client.deps.jetty.util.Jetty;
import de.mklinger.qetcher.client.deps.jetty.util.ProcessorUtils;
import de.mklinger.qetcher.client.deps.jetty.util.Promise;
import de.mklinger.qetcher.client.deps.jetty.util.SocketAddressResolver;
import de.mklinger.qetcher.client.deps.jetty.util.annotation.ManagedAttribute;
import de.mklinger.qetcher.client.deps.jetty.util.annotation.ManagedObject;
import de.mklinger.qetcher.client.deps.jetty.util.component.ContainerLifeCycle;
import de.mklinger.qetcher.client.deps.jetty.util.log.Log;
import de.mklinger.qetcher.client.deps.jetty.util.log.Logger;
import de.mklinger.qetcher.client.deps.jetty.util.ssl.SslContextFactory;
import de.mklinger.qetcher.client.deps.jetty.util.thread.QueuedThreadPool;
import de.mklinger.qetcher.client.deps.jetty.util.thread.ScheduledExecutorScheduler;
import de.mklinger.qetcher.client.deps.jetty.util.thread.Scheduler;
import de.mklinger.qetcher.client.deps.jetty.util.thread.ThreadPool;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ManagedObject(value="The HTTP client")
public class HttpClient
extends ContainerLifeCycle {
    private static final Logger LOG = Log.getLogger(HttpClient.class);
    private final ConcurrentMap<Origin, HttpDestination> destinations = new ConcurrentHashMap<Origin, HttpDestination>();
    private final ProtocolHandlers handlers = new ProtocolHandlers();
    private final List<Request.Listener> requestListeners = new ArrayList<Request.Listener>();
    private final Set<ContentDecoder.Factory> decoderFactories = new ContentDecoderFactorySet();
    private final ProxyConfiguration proxyConfig = new ProxyConfiguration();
    private final HttpClientTransport transport;
    private final SslContextFactory sslContextFactory;
    private AuthenticationStore authenticationStore = new HttpAuthenticationStore();
    private CookieManager cookieManager;
    private CookieStore cookieStore;
    private Executor executor;
    private ByteBufferPool byteBufferPool;
    private Scheduler scheduler;
    private SocketAddressResolver resolver;
    private HttpField agentField = new HttpField(HttpHeader.USER_AGENT, "Jetty/" + Jetty.VERSION);
    private boolean followRedirects = true;
    private int maxConnectionsPerDestination = 64;
    private int maxRequestsQueuedPerDestination = 1024;
    private int requestBufferSize = 4096;
    private int responseBufferSize = 16384;
    private int maxRedirects = 8;
    private SocketAddress bindAddress;
    private long connectTimeout = 15000L;
    private long addressResolutionTimeout = 15000L;
    private long idleTimeout;
    private boolean tcpNoDelay = true;
    private boolean strictEventOrdering = false;
    private HttpField encodingField;
    private boolean removeIdleDestinations = false;
    private boolean connectBlocking = false;
    private String name = this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode());
    private HttpCompliance httpCompliance = HttpCompliance.RFC7230;
    private String defaultRequestContentType = "application/octet-stream";

    public HttpClient() {
        this(null);
    }

    public HttpClient(SslContextFactory sslContextFactory) {
        this(new HttpClientTransportOverHTTP(), sslContextFactory);
    }

    public HttpClient(HttpClientTransport transport, SslContextFactory sslContextFactory) {
        this.transport = transport;
        this.sslContextFactory = sslContextFactory;
    }

    public HttpClientTransport getTransport() {
        return this.transport;
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.sslContextFactory != null) {
            this.addBean(this.sslContextFactory);
        }
        if (this.executor == null) {
            QueuedThreadPool threadPool = new QueuedThreadPool();
            threadPool.setName(this.name);
            this.executor = threadPool;
        }
        this.addBean(this.executor);
        if (this.byteBufferPool == null) {
            this.byteBufferPool = new MappedByteBufferPool(2048, this.executor instanceof ThreadPool.SizedThreadPool ? ((ThreadPool.SizedThreadPool)this.executor).getMaxThreads() / 2 : ProcessorUtils.availableProcessors() * 2);
        }
        this.addBean(this.byteBufferPool);
        if (this.scheduler == null) {
            this.scheduler = new ScheduledExecutorScheduler(this.name + "-scheduler", false);
        }
        this.addBean(this.scheduler);
        this.transport.setHttpClient(this);
        this.addBean(this.transport);
        if (this.resolver == null) {
            this.resolver = new SocketAddressResolver.Async(this.executor, this.scheduler, this.getAddressResolutionTimeout());
        }
        this.addBean(this.resolver);
        this.handlers.put(new ContinueProtocolHandler());
        this.handlers.put(new RedirectProtocolHandler(this));
        this.handlers.put(new WWWAuthenticationProtocolHandler(this));
        this.handlers.put(new ProxyAuthenticationProtocolHandler(this));
        this.decoderFactories.add(new GZIPContentDecoder.Factory(this.byteBufferPool));
        this.cookieManager = this.newCookieManager();
        this.cookieStore = this.cookieManager.getCookieStore();
        super.doStart();
    }

    private CookieManager newCookieManager() {
        return new CookieManager(this.getCookieStore(), CookiePolicy.ACCEPT_ALL);
    }

    @Override
    protected void doStop() throws Exception {
        this.decoderFactories.clear();
        this.handlers.clear();
        for (HttpDestination destination : this.destinations.values()) {
            destination.close();
        }
        this.destinations.clear();
        this.requestListeners.clear();
        this.authenticationStore.clearAuthentications();
        this.authenticationStore.clearAuthenticationResults();
        super.doStop();
    }

    public List<Request.Listener> getRequestListeners() {
        return this.requestListeners;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = Objects.requireNonNull(cookieStore);
        this.cookieManager = this.newCookieManager();
    }

    CookieManager getCookieManager() {
        return this.cookieManager;
    }

    public AuthenticationStore getAuthenticationStore() {
        return this.authenticationStore;
    }

    public void setAuthenticationStore(AuthenticationStore authenticationStore) {
        this.authenticationStore = authenticationStore;
    }

    public Set<ContentDecoder.Factory> getContentDecoderFactories() {
        return this.decoderFactories;
    }

    public ContentResponse GET(String uri) throws InterruptedException, ExecutionException, TimeoutException {
        return this.GET(URI.create(uri));
    }

    public ContentResponse GET(URI uri) throws InterruptedException, ExecutionException, TimeoutException {
        return this.newRequest(uri).send();
    }

    public ContentResponse FORM(String uri, Fields fields) throws InterruptedException, ExecutionException, TimeoutException {
        return this.FORM(URI.create(uri), fields);
    }

    public ContentResponse FORM(URI uri, Fields fields) throws InterruptedException, ExecutionException, TimeoutException {
        return this.POST(uri).content(new FormContentProvider(fields)).send();
    }

    public Request POST(String uri) {
        return this.POST(URI.create(uri));
    }

    public Request POST(URI uri) {
        return this.newRequest(uri).method(HttpMethod.POST);
    }

    public Request newRequest(String host, int port) {
        return this.newRequest(new Origin("http", host, port).asString());
    }

    public Request newRequest(String uri) {
        return this.newRequest(URI.create(uri));
    }

    public Request newRequest(URI uri) {
        return this.newHttpRequest(this.newConversation(), uri);
    }

    protected Request copyRequest(HttpRequest oldRequest, URI newURI) {
        HttpRequest newRequest = this.newHttpRequest(oldRequest.getConversation(), newURI);
        newRequest.method(oldRequest.getMethod()).version(oldRequest.getVersion()).content(oldRequest.getContent()).idleTimeout(oldRequest.getIdleTimeout(), TimeUnit.MILLISECONDS).timeout(oldRequest.getTimeout(), TimeUnit.MILLISECONDS).followRedirects(oldRequest.isFollowRedirects());
        for (HttpField field : oldRequest.getHeaders()) {
            HttpHeader header = field.getHeader();
            if (HttpHeader.HOST == header || HttpHeader.EXPECT == header || HttpHeader.COOKIE == header || HttpHeader.AUTHORIZATION == header || HttpHeader.PROXY_AUTHORIZATION == header) continue;
            String name = field.getName();
            String value = field.getValue();
            if (newRequest.getHeaders().contains(name, value)) continue;
            newRequest.header(name, value);
        }
        return newRequest;
    }

    protected HttpRequest newHttpRequest(HttpConversation conversation, URI uri) {
        return new HttpRequest(this, conversation, this.checkHost(uri));
    }

    private URI checkHost(URI uri) {
        if (uri.getHost() == null) {
            throw new IllegalArgumentException(String.format("Invalid URI host: null (authority: %s)", uri.getRawAuthority()));
        }
        return uri;
    }

    public Destination getDestination(String scheme, String host, int port) {
        return this.destinationFor(scheme, host, port);
    }

    protected HttpDestination destinationFor(String scheme, String host, int port) {
        if (!(HttpScheme.HTTP.is(scheme) || HttpScheme.HTTPS.is(scheme) || HttpScheme.WS.is(scheme) || HttpScheme.WSS.is(scheme))) {
            throw new IllegalArgumentException("Invalid protocol " + scheme);
        }
        Origin origin = new Origin(scheme = scheme.toLowerCase(Locale.ENGLISH), host = host.toLowerCase(Locale.ENGLISH), port = HttpClient.normalizePort(scheme, port));
        HttpDestination destination = (HttpDestination)this.destinations.get(origin);
        if (destination == null) {
            destination = this.transport.newHttpDestination(origin);
            this.addManaged(destination);
            HttpDestination existing = this.destinations.putIfAbsent(origin, destination);
            if (existing != null) {
                this.removeBean(destination);
                destination = existing;
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Created {}", destination);
            }
        }
        return destination;
    }

    protected boolean removeDestination(HttpDestination destination) {
        this.removeBean(destination);
        return this.destinations.remove(destination.getOrigin(), destination);
    }

    public List<Destination> getDestinations() {
        return new ArrayList<Destination>(this.destinations.values());
    }

    protected void send(HttpRequest request, List<Response.ResponseListener> listeners) {
        HttpDestination destination = this.destinationFor(request.getScheme(), request.getHost(), request.getPort());
        destination.send(request, listeners);
    }

    protected void newConnection(final HttpDestination destination, final Promise<Connection> promise) {
        Origin.Address address = destination.getConnectAddress();
        this.resolver.resolve(address.getHost(), address.getPort(), new Promise<List<InetSocketAddress>>(){

            @Override
            public void succeeded(List<InetSocketAddress> socketAddresses) {
                HashMap<String, Object> context = new HashMap<String, Object>();
                context.put("client.connector", HttpClient.this);
                context.put("http.destination", destination);
                this.connect(socketAddresses, 0, context);
            }

            @Override
            public void failed(Throwable x) {
                promise.failed(x);
            }

            private void connect(final List<InetSocketAddress> socketAddresses, final int index, final Map<String, Object> context) {
                context.put("http.connection.promise", new Promise.Wrapper<Connection>(promise){

                    @Override
                    public void failed(Throwable x) {
                        int nextIndex = index + 1;
                        if (nextIndex == socketAddresses.size()) {
                            super.failed(x);
                        } else {
                            this.connect(socketAddresses, nextIndex, context);
                        }
                    }
                });
                HttpClient.this.transport.connect(socketAddresses.get(index), context);
            }
        });
    }

    private HttpConversation newConversation() {
        return new HttpConversation();
    }

    public ProtocolHandlers getProtocolHandlers() {
        return this.handlers;
    }

    protected ProtocolHandler findProtocolHandler(Request request, Response response) {
        return this.handlers.find(request, response);
    }

    public ByteBufferPool getByteBufferPool() {
        return this.byteBufferPool;
    }

    public void setByteBufferPool(ByteBufferPool byteBufferPool) {
        this.byteBufferPool = byteBufferPool;
    }

    @ManagedAttribute(value="The name of this HttpClient")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ManagedAttribute(value="The timeout, in milliseconds, for connect() operations")
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getAddressResolutionTimeout() {
        return this.addressResolutionTimeout;
    }

    public void setAddressResolutionTimeout(long addressResolutionTimeout) {
        this.addressResolutionTimeout = addressResolutionTimeout;
    }

    @ManagedAttribute(value="The timeout, in milliseconds, to close idle connections")
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public HttpField getUserAgentField() {
        return this.agentField;
    }

    public void setUserAgentField(HttpField agent) {
        if (agent != null && agent.getHeader() != HttpHeader.USER_AGENT) {
            throw new IllegalArgumentException();
        }
        this.agentField = agent;
    }

    @ManagedAttribute(value="Whether HTTP redirects are followed")
    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean follow) {
        this.followRedirects = follow;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public SocketAddressResolver getSocketAddressResolver() {
        return this.resolver;
    }

    public void setSocketAddressResolver(SocketAddressResolver resolver) {
        this.resolver = resolver;
    }

    @ManagedAttribute(value="The max number of connections per each destination")
    public int getMaxConnectionsPerDestination() {
        return this.maxConnectionsPerDestination;
    }

    public void setMaxConnectionsPerDestination(int maxConnectionsPerDestination) {
        this.maxConnectionsPerDestination = maxConnectionsPerDestination;
    }

    @ManagedAttribute(value="The max number of requests queued per each destination")
    public int getMaxRequestsQueuedPerDestination() {
        return this.maxRequestsQueuedPerDestination;
    }

    public void setMaxRequestsQueuedPerDestination(int maxRequestsQueuedPerDestination) {
        this.maxRequestsQueuedPerDestination = maxRequestsQueuedPerDestination;
    }

    @ManagedAttribute(value="The request buffer size")
    public int getRequestBufferSize() {
        return this.requestBufferSize;
    }

    public void setRequestBufferSize(int requestBufferSize) {
        this.requestBufferSize = requestBufferSize;
    }

    @ManagedAttribute(value="The response buffer size")
    public int getResponseBufferSize() {
        return this.responseBufferSize;
    }

    public void setResponseBufferSize(int responseBufferSize) {
        this.responseBufferSize = responseBufferSize;
    }

    public int getMaxRedirects() {
        return this.maxRedirects;
    }

    public void setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    @ManagedAttribute(value="Whether the TCP_NODELAY option is enabled", name="tcpNoDelay")
    public boolean isTCPNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTCPNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    @Deprecated
    public boolean isDispatchIO() {
        return false;
    }

    @Deprecated
    public void setDispatchIO(boolean dispatchIO) {
    }

    public HttpCompliance getHttpCompliance() {
        return this.httpCompliance;
    }

    public void setHttpCompliance(HttpCompliance httpCompliance) {
        this.httpCompliance = httpCompliance;
    }

    @ManagedAttribute(value="Whether request/response events must be strictly ordered")
    public boolean isStrictEventOrdering() {
        return this.strictEventOrdering;
    }

    public void setStrictEventOrdering(boolean strictEventOrdering) {
        this.strictEventOrdering = strictEventOrdering;
    }

    @ManagedAttribute(value="Whether idle destinations are removed")
    public boolean isRemoveIdleDestinations() {
        return this.removeIdleDestinations;
    }

    public void setRemoveIdleDestinations(boolean removeIdleDestinations) {
        this.removeIdleDestinations = removeIdleDestinations;
    }

    @ManagedAttribute(value="Whether the connect() operation is blocking")
    public boolean isConnectBlocking() {
        return this.connectBlocking;
    }

    public void setConnectBlocking(boolean connectBlocking) {
        this.connectBlocking = connectBlocking;
    }

    @ManagedAttribute(value="The default content type for request content")
    public String getDefaultRequestContentType() {
        return this.defaultRequestContentType;
    }

    public void setDefaultRequestContentType(String contentType) {
        this.defaultRequestContentType = contentType;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfig;
    }

    protected HttpField getAcceptEncodingField() {
        return this.encodingField;
    }

    protected String normalizeHost(String host) {
        if (host != null && host.matches("\\[.*\\]")) {
            return host.substring(1, host.length() - 1);
        }
        return host;
    }

    public static int normalizePort(String scheme, int port) {
        if (port > 0) {
            return port;
        }
        if (HttpClient.isSchemeSecure(scheme)) {
            return 443;
        }
        return 80;
    }

    public boolean isDefaultPort(String scheme, int port) {
        if (HttpClient.isSchemeSecure(scheme)) {
            return port == 443;
        }
        return port == 80;
    }

    static boolean isSchemeSecure(String scheme) {
        return HttpScheme.HTTPS.is(scheme) || HttpScheme.WSS.is(scheme);
    }

    protected ClientConnectionFactory newSslClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        return new SslClientConnectionFactory(this.getSslContextFactory(), this.getByteBufferPool(), this.getExecutor(), connectionFactory);
    }

    private class ContentDecoderFactorySet
    implements Set<ContentDecoder.Factory> {
        private final Set<ContentDecoder.Factory> set = new HashSet<ContentDecoder.Factory>();

        private ContentDecoderFactorySet() {
        }

        @Override
        public boolean add(ContentDecoder.Factory e) {
            boolean result = this.set.add(e);
            this.invalidate();
            return result;
        }

        @Override
        public boolean addAll(Collection<? extends ContentDecoder.Factory> c) {
            boolean result = this.set.addAll(c);
            this.invalidate();
            return result;
        }

        @Override
        public boolean remove(Object o) {
            boolean result = this.set.remove(o);
            this.invalidate();
            return result;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean result = this.set.removeAll(c);
            this.invalidate();
            return result;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            boolean result = this.set.retainAll(c);
            this.invalidate();
            return result;
        }

        @Override
        public void clear() {
            this.set.clear();
            this.invalidate();
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.set.containsAll(c);
        }

        @Override
        public Iterator<ContentDecoder.Factory> iterator() {
            final Iterator<ContentDecoder.Factory> iterator = this.set.iterator();
            return new Iterator<ContentDecoder.Factory>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public ContentDecoder.Factory next() {
                    return (ContentDecoder.Factory)iterator.next();
                }

                @Override
                public void remove() {
                    iterator.remove();
                    ContentDecoderFactorySet.this.invalidate();
                }
            };
        }

        @Override
        public Object[] toArray() {
            return this.set.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.set.toArray(a);
        }

        private void invalidate() {
            if (this.set.isEmpty()) {
                HttpClient.this.encodingField = null;
            } else {
                StringBuilder value = new StringBuilder();
                Iterator<ContentDecoder.Factory> iterator = this.set.iterator();
                while (iterator.hasNext()) {
                    ContentDecoder.Factory decoderFactory = iterator.next();
                    value.append(decoderFactory.getEncoding());
                    if (!iterator.hasNext()) continue;
                    value.append(",");
                }
                HttpClient.this.encodingField = new HttpField(HttpHeader.ACCEPT_ENCODING, value.toString());
            }
        }
    }
}

