/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.deps.jackson.databind.ser.std;

import de.mklinger.qetcher.client.deps.jackson.core.JsonGenerator;
import de.mklinger.qetcher.client.deps.jackson.core.JsonToken;
import de.mklinger.qetcher.client.deps.jackson.core.type.WritableTypeId;
import de.mklinger.qetcher.client.deps.jackson.databind.JavaType;
import de.mklinger.qetcher.client.deps.jackson.databind.JsonMappingException;
import de.mklinger.qetcher.client.deps.jackson.databind.JsonNode;
import de.mklinger.qetcher.client.deps.jackson.databind.SerializerProvider;
import de.mklinger.qetcher.client.deps.jackson.databind.annotation.JacksonStdImpl;
import de.mklinger.qetcher.client.deps.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import de.mklinger.qetcher.client.deps.jackson.databind.jsontype.TypeSerializer;
import de.mklinger.qetcher.client.deps.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ToStringSerializer
extends StdSerializer<Object> {
    public static final ToStringSerializer instance = new ToStringSerializer();

    public ToStringSerializer() {
        super(Object.class);
    }

    public ToStringSerializer(Class<?> handledType) {
        super(handledType, false);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Object value) {
        return value.toString().isEmpty();
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeString(value.toString());
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator g, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, typeSer.typeId(value, JsonToken.VALUE_STRING));
        this.serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

