/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.common;

import java.io.PrintWriter;
import java.io.StringWriter;

public class Throwables {
    private Throwables() {
    }

    public static String stackTraceToString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static <T extends Throwable> T firstCause(Throwable e, Class<T> errorType) {
        if (e == null) {
            return null;
        }
        if (errorType.isAssignableFrom(e.getClass())) {
            return (T)e;
        }
        return Throwables.firstCause(e.getCause(), errorType);
    }

    public static boolean hasCause(Throwable e, Class<? extends Throwable> errorType) {
        return Throwables.firstCause(e, errorType) != null;
    }
}

