package de.mklinger.qetcher.client.model.v1.impl;

import java.util.List;

import de.mklinger.qetcher.client.common.Lists;
import de.mklinger.qetcher.client.model.v1.AvailableNode;
import de.mklinger.qetcher.client.model.v1.AvailableNodes;
import de.mklinger.qetcher.client.model.v1.builder.AvailableNodesBuilder;

/**
 * All client available nodes in the cluster.
 *
 * This model class is not used internally, but only in v1 REST service and
 * Qetcher client.
 *
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class AvailableNodesImpl implements AvailableNodes {
	private final List<AvailableNode> availableNodes;

	public AvailableNodesImpl(final AvailableNodesBuilder builder) {
		this.availableNodes = Lists.newImmutableList(builder.getAvailableNodes());
	}

	@Override
	public List<AvailableNode> getAvailableNodes() {
		return availableNodes;
	}
}
