package de.mklinger.qetcher.client.model.v1;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public enum NodeLifecycle {
	/** Indicates the node is starting. */
	NODE_STARTING,
	/** The node is up, but there are converters in error state. */
	PARTIALLY_FUNCTIONAL,
	/** Everything is running perfectly fine. */
	FULLY_FUNCTIONAL,
	/** Indicates the node is stopping. */
	NODE_STOPPING;

	public boolean isFunctional() {
		return this == FULLY_FUNCTIONAL
				|| this == PARTIALLY_FUNCTIONAL;
	}
}
