package de.mklinger.qetcher.client.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author Marc Klinger - mklinger[at]mklinger[dot]de
 */
public class Lists {
	/** No instantiation */
	private Lists() {}

	public static <T> List<T> newImmutableList(final List<T> original) {
		if (original == null || original.isEmpty()) {
			return Collections.emptyList();
		}
		if (original.size() == 1) {
			return Collections.singletonList(original.get(0));
		}
		return Collections.unmodifiableList(new ArrayList<>(original));
	}
}
