/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.model.v1.jackson;

import de.mklinger.qetcher.client.deps.jackson.databind.annotation.JsonPOJOBuilder;
import de.mklinger.qetcher.client.deps.jackson.databind.introspect.AnnotatedClass;
import de.mklinger.qetcher.client.deps.jackson.databind.introspect.JacksonAnnotationIntrospector;
import de.mklinger.qetcher.client.model.v1.V1;
import java.lang.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QetcherJacksonAnnotationIntrospector
extends JacksonAnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(QetcherJacksonAnnotationIntrospector.class);
    private static final String MODEL_PACKAGE_NAME = V1.class.getPackage().getName();
    private static final String MODEL_PACKAGE_SUB_PREFIX = MODEL_PACKAGE_NAME + ".";
    private static final String MODEL_BUILDER_PACKAGE = MODEL_PACKAGE_SUB_PREFIX + "builder.";
    private static final JsonPOJOBuilder DEFAULT_POJO_BUILDER = new JsonPOJOBuilder(){

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.getClass();
        }

        @Override
        public String withPrefix() {
            return "";
        }

        @Override
        public String buildMethodName() {
            return "build";
        }
    };

    @Override
    public Class<?> findPOJOBuilder(AnnotatedClass ac) {
        Class<?> builder = super.findPOJOBuilder(ac);
        if (builder == null && this.isModelPackageClass(ac)) {
            String innerBuilderClassName = this.getBuilderClassName(ac);
            try {
                builder = ac.getRawType().getClassLoader().loadClass(innerBuilderClassName);
            }
            catch (ClassNotFoundException e) {
                LOG.debug("Builder class not found: {}", (Object)innerBuilderClassName, (Object)e);
            }
        }
        if (builder == null) {
            LOG.debug("No builder found for {}", ac.getRawType());
        } else {
            LOG.debug("Using builder {} for {}", builder, ac.getRawType());
        }
        return builder;
    }

    private String getBuilderClassName(AnnotatedClass ac) {
        String simpleClassName = ac.getRawType().getSimpleName();
        if (simpleClassName.endsWith("Impl")) {
            simpleClassName = simpleClassName.substring(0, simpleClassName.length() - "Impl".length());
        }
        return MODEL_BUILDER_PACKAGE + simpleClassName + "Builder";
    }

    @Override
    public JsonPOJOBuilder.Value findPOJOBuilderConfig(AnnotatedClass ac) {
        JsonPOJOBuilder.Value value = super.findPOJOBuilderConfig(ac);
        if (value == null && this.isModelPackageClass(ac)) {
            value = new JsonPOJOBuilder.Value(DEFAULT_POJO_BUILDER);
        }
        return value;
    }

    private boolean isModelPackageClass(AnnotatedClass ac) {
        Package pakkage = ac.getRawType().getPackage();
        if (pakkage == null) {
            return false;
        }
        String packageName = pakkage.getName();
        return packageName.equals(MODEL_PACKAGE_NAME) || packageName.startsWith(MODEL_PACKAGE_SUB_PREFIX);
    }
}

