/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.model.v1.builder;

import de.mklinger.qetcher.client.common.MediaType;
import de.mklinger.qetcher.client.model.v1.Conversion;
import de.mklinger.qetcher.client.model.v1.impl.ConversionImpl;
import java.util.HashSet;
import java.util.Set;

public class ConversionBuilder {
    private MediaType from;
    private MediaType to;
    private int priority;
    private Set<String> supportedParameters;

    public static ConversionBuilder of(Conversion conversion) {
        return new ConversionBuilder().from(conversion.getFrom()).to(conversion.getTo()).priority(conversion.getPriority()).supportedParameters(conversion.getSupportedParameters());
    }

    public ConversionBuilder from(MediaType from) {
        this.from = from;
        return this;
    }

    public ConversionBuilder to(MediaType to) {
        this.to = to;
        return this;
    }

    public ConversionBuilder priority(int priority) {
        this.priority = priority;
        return this;
    }

    public ConversionBuilder supportedParameters(Set<String> supportedParameters) {
        this.supportedParameters = supportedParameters == null || supportedParameters.isEmpty() ? null : new HashSet<String>(supportedParameters);
        return this;
    }

    public ConversionBuilder withSupportedParameter(String supportedParameter) {
        if (this.supportedParameters == null) {
            this.supportedParameters = new HashSet<String>();
        }
        this.supportedParameters.add(supportedParameter);
        return this;
    }

    public MediaType getFrom() {
        return this.from;
    }

    public MediaType getTo() {
        return this.to;
    }

    public int getPriority() {
        return this.priority;
    }

    public Set<String> getSupportedParameters() {
        return this.supportedParameters;
    }

    public Conversion build() {
        return new ConversionImpl(this);
    }
}

