/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.httpclient.internal.jetty;

import de.mklinger.qetcher.client.deps.jetty.client.api.Request;
import de.mklinger.qetcher.client.deps.jetty.client.api.Response;
import de.mklinger.qetcher.client.deps.jetty.client.api.Result;
import de.mklinger.qetcher.client.deps.jetty.io.CyclicTimeout;
import de.mklinger.qetcher.client.deps.jetty.util.thread.Scheduler;
import de.mklinger.qetcher.client.httpclient.internal.jetty.ResponseListenerWrapper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutResponseListener
extends ResponseListenerWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(TimeoutResponseListener.class);
    private final CyclicTimeout cyclicTimeout;

    public TimeoutResponseListener(Response.Listener delegate, final Request request, final long timeout, final TimeUnit timeUnit, Scheduler scheduler) {
        super(delegate);
        this.cyclicTimeout = new CyclicTimeout(scheduler){

            @Override
            public void onTimeoutExpired() {
                long millis = timeUnit.toMillis(timeout);
                LOG.info("Timeout {} ms elapsed for {}", (Object)millis, (Object)request);
                request.abort(new TimeoutException("Total timeout " + millis + " ms elapsed"));
            }
        };
        this.cyclicTimeout.schedule(timeout, timeUnit);
    }

    @Override
    public void onComplete(Result result) {
        try {
            this.cyclicTimeout.cancel();
        }
        catch (Throwable e) {
            LOG.error("Error cancelling timeout", e);
        }
        super.onComplete(result);
    }
}

