/*
 * Decompiled with CFR 0.152.
 */
package de.mklinger.qetcher.client.httpclient.internal.jetty;

import de.mklinger.qetcher.client.httpclient.HttpHeaders;
import de.mklinger.qetcher.client.httpclient.HttpRequest;
import de.mklinger.qetcher.client.httpclient.HttpResponse;
import java.net.URI;
import java.util.Objects;

public class JettyHttpResponse<T>
implements HttpResponse<T> {
    private final HttpRequest request;
    private final int statusCode;
    private final HttpHeaders headers;
    private final T body;

    public JettyHttpResponse(int statusCode, HttpRequest request, HttpHeaders headers, T body) {
        this.request = Objects.requireNonNull(request);
        this.statusCode = JettyHttpResponse.requireValidStatusCode(statusCode);
        this.headers = Objects.requireNonNull(headers);
        this.body = body;
    }

    private static int requireValidStatusCode(int statusCode) {
        if (statusCode < 100 || statusCode > 999) {
            throw new IllegalArgumentException();
        }
        return statusCode;
    }

    @Override
    public URI uri() {
        return this.request.uri();
    }

    @Override
    public HttpRequest request() {
        return this.request;
    }

    @Override
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public T body() {
        return this.body;
    }
}

